/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packet;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.ProtocolInfo;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.protocols.base.ClientboundLoginPackets;
import com.viaversion.viaversion.protocols.base.ServerboundHandshakePackets;
import com.viaversion.viaversion.protocols.base.ServerboundLoginPackets;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwsHeader;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.SecureDigestAlgorithm;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.io.compression.ProtocolCompression;
import net.raphimc.viabedrock.api.util.CryptUtil;
import net.raphimc.viabedrock.api.util.FNV1;
import net.raphimc.viabedrock.api.util.Jwt;
import net.raphimc.viabedrock.api.util.PacketFactory;
import net.raphimc.viabedrock.api.util.ServerBlacklist;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.AuthenticationType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.PacketCompressionAlgorithm;
import net.raphimc.viabedrock.protocol.provider.NettyPipelineProvider;
import net.raphimc.viabedrock.protocol.provider.SkinProvider;
import net.raphimc.viabedrock.protocol.storage.AuthData;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.HandshakeStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class LoginPackets {
    private static final int CLOCK_SKEW = 60;

    public static void register(BedrockProtocol protocol) {
        protocol.registerClientbound(ClientboundBedrockPackets.NETWORK_SETTINGS, null, wrapper -> {
            wrapper.cancel();
            GameSessionStorage gameSession = (GameSessionStorage)wrapper.user().get(GameSessionStorage.class);
            HandshakeStorage handshakeStorage = (HandshakeStorage)wrapper.user().get(HandshakeStorage.class);
            AuthData authData = (AuthData)wrapper.user().get(AuthData.class);
            int threshold = (Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_SHORT_LE);
            PacketCompressionAlgorithm algorithm = PacketCompressionAlgorithm.getByValue((Integer)wrapper.read((Type)BedrockTypes.UNSIGNED_SHORT_LE), PacketCompressionAlgorithm.None);
            ProtocolCompression protocolCompression = new ProtocolCompression(algorithm, threshold);
            if (gameSession.getProtocolCompression() == null) {
                ((NettyPipelineProvider)Via.getManager().getProviders().get(NettyPipelineProvider.class)).enableCompression(wrapper.user(), protocolCompression);
            } else {
                gameSession.getProtocolCompression().end();
            }
            gameSession.setProtocolCompression(protocolCompression);
            JsonObject authInfoObj = new JsonObject();
            List<String> certificateChain = authData.getCertificateChain();
            boolean fullAuth = authData.getMultiplayerToken() != null || certificateChain.size() == 3;
            authInfoObj.addProperty("AuthenticationType", (Number)(fullAuth ? AuthenticationType.Full : AuthenticationType.SelfSigned).ordinal());
            if (!certificateChain.isEmpty()) {
                JsonObject certificateChainObj = new JsonObject();
                certificateChainObj.add("chain", (JsonElement)certificateChain.stream().collect(JsonArray::new, JsonArray::add, JsonArray::addAll));
                authInfoObj.addProperty("Certificate", certificateChainObj.toString());
            } else {
                authInfoObj.addProperty("Certificate", "");
            }
            authInfoObj.addProperty("Token", authData.getMultiplayerToken() != null ? authData.getMultiplayerToken() : "");
            String authInfo = authInfoObj.toString();
            PacketWrapper login = PacketWrapper.create((PacketType)ServerboundBedrockPackets.LOGIN, (UserConnection)wrapper.user());
            login.write((Type)Types.INT, (Object)handshakeStorage.protocolVersion());
            login.write((Type)BedrockTypes.UNSIGNED_VAR_INT, (Object)(authInfo.length() + authData.getSkinJwt().length() + 8));
            login.write(BedrockTypes.ASCII_STRING, (Object)authInfo);
            login.write(BedrockTypes.ASCII_STRING, (Object)authData.getSkinJwt());
            login.sendToServer(BedrockProtocol.class);
        });
        protocol.registerClientbound(ClientboundBedrockPackets.SERVER_TO_CLIENT_HANDSHAKE, null, wrapper -> {
            wrapper.cancel();
            AuthData authData = (AuthData)wrapper.user().get(AuthData.class);
            Jws jwt = Jwts.parser().clockSkewSeconds(60L).keyLocator(CryptUtil.X5U_KEY_LOCATOR).build().parseSignedClaims((CharSequence)wrapper.read(BedrockTypes.STRING));
            try {
                byte[] salt = Base64.getDecoder().decode((String)((Claims)jwt.getPayload()).get("salt", String.class));
                SecretKey secretKey = LoginPackets.ecdhKeyExchange((ECPrivateKey)authData.getSessionKeyPair().getPrivate(), CryptUtil.ecPublicKeyFromBase64((String)((JwsHeader)jwt.getHeader()).get((Object)"x5u")), salt);
                ((NettyPipelineProvider)Via.getManager().getProviders().get(NettyPipelineProvider.class)).enableEncryption(wrapper.user(), secretKey);
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to enable encryption", e);
            }
            PacketWrapper clientToServerHandshake = PacketWrapper.create((PacketType)ServerboundBedrockPackets.CLIENT_TO_SERVER_HANDSHAKE, (UserConnection)wrapper.user());
            clientToServerHandshake.sendToServer(BedrockProtocol.class);
        });
        protocol.registerServerboundTransition((ServerboundPacketType)ServerboundHandshakePackets.CLIENT_INTENTION, null, wrapper -> {
            wrapper.cancel();
            int protocolVersion = (Integer)wrapper.read((Type)Types.VAR_INT);
            String hostname = (String)wrapper.read(Types.STRING);
            int port = (Integer)wrapper.read((Type)Types.UNSIGNED_SHORT);
            wrapper.user().put((StorableObject)new HandshakeStorage(protocolVersion, hostname, port));
        });
        protocol.registerServerboundTransition((ServerboundPacketType)ServerboundLoginPackets.HELLO, ServerboundBedrockPackets.REQUEST_NETWORK_SETTINGS, wrapper -> {
            HandshakeStorage handshakeStorage = (HandshakeStorage)wrapper.user().get(HandshakeStorage.class);
            if (!ViaBedrock.getConfig().shouldDisableServerBlacklist() && ServerBlacklist.isBlacklisted(handshakeStorage.hostname())) {
                wrapper.cancel();
                try {
                    PacketWrapper loginDisconnect = PacketWrapper.create((PacketType)ClientboundLoginPackets.LOGIN_DISCONNECT, (UserConnection)wrapper.user());
                    PacketFactory.writeJavaDisconnect(loginDisconnect, "\u00a7cThis server is blacklisted by ViaBedrock because the server is known to ban players joining with ViaBedrock (Due to the server's anti-cheat).\n\n\u00a77If you want to join the server anyway, set disable-server-blacklist to true in the ViaBedrock config file.");
                    loginDisconnect.send(BedrockProtocol.class);
                }
                catch (Throwable loginDisconnect) {
                    // empty catch block
                }
                if (wrapper.user().getChannel() != null) {
                    wrapper.user().getChannel().flush();
                    wrapper.user().getChannel().close();
                }
                return;
            }
            ProtocolInfo protocolInfo = wrapper.user().getProtocolInfo();
            protocolInfo.setUsername((String)wrapper.read(Types.STRING));
            protocolInfo.setUuid((UUID)wrapper.read(Types.UUID));
            wrapper.write((Type)Types.INT, (Object)handshakeStorage.protocolVersion());
            try {
                LoginPackets.validateAndFillAuthData(wrapper.user());
            }
            catch (Throwable e) {
                throw new RuntimeException("Could not validate and fill auth data", e);
            }
        });
        protocol.registerServerboundTransition((ServerboundPacketType)ServerboundLoginPackets.LOGIN_ACKNOWLEDGED, null, PacketWrapper::cancel);
    }

    private static void validateAndFillAuthData(UserConnection user) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException {
        AuthData authData;
        if (user.has(AuthData.class)) {
            authData = (AuthData)user.get(AuthData.class);
            if (authData.getMojangJwt() != null && authData.getSelfSignedJwt() == null) {
                KeyPair sessionKeyPair = authData.getSessionKeyPair();
                Jwt mojangJwt = Jwt.parse(authData.getMojangJwt());
                authData.setSelfSignedJwt(((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().signWith((Key)sessionKeyPair.getPrivate(), (SecureDigestAlgorithm)Jwts.SIG.ES384).header().add((Object)"x5u", (Object)Base64.getEncoder().encodeToString(sessionKeyPair.getPublic().getEncoded()))).and()).claim("certificateAuthority", (Object)true).claim("identityPublicKey", (Object)mojangJwt.header().get("x5u").getAsString()).expiration(Date.from(Instant.now().plus(2L, ChronoUnit.DAYS))).notBefore(Date.from(Instant.now().minus(1L, ChronoUnit.MINUTES))).compact());
            }
        } else {
            KeyPair sessionKeyPair = CryptUtil.generateEcdsa384KeyPair();
            String encodedPublicKey = Base64.getEncoder().encodeToString(sessionKeyPair.getPublic().getEncoded());
            long xuid = Math.abs(FNV1.fnv1_64(user.getProtocolInfo().getUsername().getBytes(StandardCharsets.UTF_8)));
            HashMap<String, Object> extraData = new HashMap<String, Object>();
            extraData.put("displayName", user.getProtocolInfo().getUsername());
            extraData.put("XUID", String.valueOf(xuid));
            extraData.put("identity", UUID.nameUUIDFromBytes(("pocket-auth-1-xuid:" + xuid).getBytes(StandardCharsets.UTF_8)));
            String identityJwt = ((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().signWith((Key)sessionKeyPair.getPrivate(), (SecureDigestAlgorithm)Jwts.SIG.ES384).header().add((Object)"x5u", (Object)encodedPublicKey)).and()).claim("identityPublicKey", (Object)encodedPublicKey).claim("extraData", extraData).expiration(Date.from(Instant.now().plus(365L, ChronoUnit.DAYS))).notBefore(Date.from(Instant.now().minus(1L, ChronoUnit.MINUTES))).compact();
            user.put((StorableObject)new AuthData(null, identityJwt, null, sessionKeyPair, UUID.randomUUID()));
        }
        authData = (AuthData)user.get(AuthData.class);
        if (authData.getSkinJwt() == null) {
            authData.setSkinJwt(((JwtBuilder)((JwtBuilder.BuilderHeader)Jwts.builder().signWith((Key)authData.getSessionKeyPair().getPrivate(), (SecureDigestAlgorithm)Jwts.SIG.ES384).header().add((Object)"x5u", (Object)Base64.getEncoder().encodeToString(authData.getSessionKeyPair().getPublic().getEncoded()))).and()).claims(((SkinProvider)Via.getManager().getProviders().get(SkinProvider.class)).getClientPlayerSkin(user)).compact());
        }
        if (authData.getMultiplayerToken() != null) {
            Jwt multiplayerTokenJwt = Jwt.parse(authData.getMultiplayerToken());
            authData.setDisplayName(multiplayerTokenJwt.payload().get("xname").getAsString());
            authData.setXuid(multiplayerTokenJwt.payload().get("xid").getAsString());
        } else if (authData.getIdentityJwt() != null) {
            Jwt identityJwt = Jwt.parse(authData.getIdentityJwt());
            JsonObject extraData = identityJwt.payload().getAsJsonObject("extraData");
            authData.setDisplayName(extraData.get("displayName").getAsString());
            authData.setXuid(extraData.get("XUID").getAsString());
        } else {
            throw new IllegalStateException("No multiplayer token or identity token present to extract display name and XUID from");
        }
    }

    private static SecretKey ecdhKeyExchange(ECPrivateKey localPrivateKey, ECPublicKey remotePublicKey, byte[] salt) throws NoSuchAlgorithmException, InvalidKeyException {
        KeyAgreement ecdh = KeyAgreement.getInstance("ECDH");
        ecdh.init(localPrivateKey);
        ecdh.doPhase(remotePublicKey, true);
        byte[] sharedSecret = ecdh.generateSecret();
        MessageDigest sha256 = MessageDigest.getInstance("SHA-256");
        sha256.update(salt);
        sha256.update(sharedSecret);
        return new SecretKeySpec(sha256.digest(), "AES");
    }
}

