/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.packet;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.ServerboundPacketType;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundConfigurationPackets1_21_9;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ServerboundConfigurationPackets1_21_9;
import com.viaversion.viaversion.util.Pair;
import com.viaversion.viaversion.util.Triple;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.http.BedrockPackDownloader;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.api.util.TextUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ClientboundBedrockPackets;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.ProtocolConstants;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.PackType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ResourcePackResponse;
import net.raphimc.viabedrock.protocol.data.enums.java.ResourcePackAction;
import net.raphimc.viabedrock.protocol.model.Experiment;
import net.raphimc.viabedrock.protocol.provider.ResourcePackProvider;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class ResourcePackPackets {
    public static void register(BedrockProtocol protocol) {
        protocol.registerClientboundTransition(ClientboundBedrockPackets.RESOURCE_PACKS_INFO, ClientboundConfigurationPackets1_21_9.RESOURCE_PACK_PUSH, wrapper -> {
            ResourcePack[] resourcePacks;
            wrapper.cancel();
            if (wrapper.user().has(ResourcePacksStorage.class) && ((ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class)).hasFinishedLoading()) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACKS_INFO after loading completion");
                return;
            }
            ResourcePacksStorage resourcePacksStorage = new ResourcePacksStorage(wrapper.user());
            wrapper.user().put((StorableObject)resourcePacksStorage);
            wrapper.read((Type)Types.BOOLEAN);
            wrapper.read((Type)Types.BOOLEAN);
            wrapper.read((Type)Types.BOOLEAN);
            wrapper.read((Type)Types.BOOLEAN);
            wrapper.read(BedrockTypes.UUID);
            wrapper.read(BedrockTypes.STRING);
            for (ResourcePack resourcePack : resourcePacks = (ResourcePack[])wrapper.read(BedrockTypes.RESOURCE_PACK_ARRAY)) {
                resourcePacksStorage.addPack(resourcePack);
            }
            if (ViaBedrock.getConfig().shouldTranslateResourcePacks() && wrapper.user().getProtocolInfo().protocolVersion().newerThanOrEqualTo(ProtocolConstants.JAVA_VERSION)) {
                CompletableFuture<Void> httpFuture = resourcePacksStorage.runHttpTask(resourcePacksStorage.getPacks(), pack -> {
                    BedrockPackDownloader downloader = new BedrockPackDownloader(pack.cdnUrl());
                    int contentLength = downloader.getContentLength();
                    pack.setCompressedDataLength(contentLength, contentLength);
                }, (pack, e) -> {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to get content length for pack: " + String.valueOf(pack.packId()) + " (" + String.valueOf(pack.cdnUrl()) + ")", (Throwable)e);
                    pack.setCdnUrl(null);
                });
                UUID httpToken = UUID.randomUUID();
                ViaBedrock.getResourcePackServer().addConnection(httpToken, wrapper.user());
                PacketWrapper resourcePackPush = PacketWrapper.create((PacketType)wrapper.getPacketType(), (UserConnection)wrapper.user());
                resourcePackPush.write(Types.UUID, (Object)UUID.randomUUID());
                resourcePackPush.write(Types.STRING, (Object)(ViaBedrock.getResourcePackServer().getUrl() + "?token=" + String.valueOf(httpToken)));
                resourcePackPush.write(Types.STRING, (Object)"");
                resourcePackPush.write((Type)Types.BOOLEAN, (Object)false);
                resourcePackPush.write(Types.OPTIONAL_TAG, (Object)TextUtil.stringToNbt("\n\u00a7aIf you press 'Yes', the resource packs will be downloaded and converted to the Java Edition format. This may take a while, depending on your internet connection and the size of the packs. If you press 'No', you can join without loading the resource packs but you will have a worse gameplay experience."));
                httpFuture.thenRun(() -> resourcePackPush.scheduleSend(BedrockProtocol.class));
            } else {
                PacketWrapper resourcePack = PacketWrapper.create((PacketType)ServerboundConfigurationPackets1_21_9.RESOURCE_PACK, (UserConnection)wrapper.user());
                resourcePack.write(Types.UUID, (Object)UUID.randomUUID());
                resourcePack.write((Type)Types.VAR_INT, (Object)ResourcePackAction.DECLINED.ordinal());
                resourcePack.sendToServer(BedrockProtocol.class, false);
            }
        }, State.PLAY, wrapper -> {
            wrapper.cancel();
            if (wrapper.user().has(ResourcePacksStorage.class) && ((ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class)).hasFinishedLoading()) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACKS_INFO after loading completion");
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.RESOURCE_PACK_DATA_INFO, null, wrapper -> {
            wrapper.cancel();
            ResourcePacksStorage resourcePacksStorage = (ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class);
            if (resourcePacksStorage.hasFinishedLoading()) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACK_DATA_INFO after loading completion");
                return;
            }
            Pair idAndVersion = (Pair)wrapper.read(BedrockTypes.PACK_ID_AND_VERSION);
            int maxChunkSize = ((Long)wrapper.read((Type)BedrockTypes.UNSIGNED_INT_LE)).intValue();
            wrapper.read((Type)BedrockTypes.UNSIGNED_INT_LE);
            long compressedPackSize = (Long)wrapper.read((Type)BedrockTypes.LONG_LE);
            byte[] hash = (byte[])wrapper.read(BedrockTypes.BYTE_ARRAY);
            boolean premium = (Boolean)wrapper.read((Type)Types.BOOLEAN);
            PackType type = PackType.getByValue(((Byte)wrapper.read((Type)Types.BYTE)).byteValue(), PackType.Invalid);
            int actualChunkCount = (int)Math.ceil((double)compressedPackSize / (double)maxChunkSize);
            if (resourcePacksStorage.hasPack((UUID)idAndVersion.key())) {
                ResourcePack resourcePack = resourcePacksStorage.getPack((UUID)idAndVersion.key());
                resourcePack.setHash(hash);
                resourcePack.setPremium(premium);
                resourcePack.setType(type);
                resourcePack.setCompressedDataLength((int)compressedPackSize, maxChunkSize);
            } else {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACK_DATA_INFO for unknown pack: " + String.valueOf(idAndVersion.key()));
            }
            for (int i = 0; i < actualChunkCount; ++i) {
                PacketWrapper resourcePackChunkRequest = wrapper.create((PacketType)ServerboundBedrockPackets.RESOURCE_PACK_CHUNK_REQUEST);
                resourcePackChunkRequest.write(BedrockTypes.PACK_ID_AND_VERSION, (Object)idAndVersion);
                resourcePackChunkRequest.write((Type)BedrockTypes.INT_LE, (Object)i);
                resourcePackChunkRequest.sendToServer(BedrockProtocol.class);
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.RESOURCE_PACK_CHUNK_DATA, null, wrapper -> {
            wrapper.cancel();
            ResourcePacksStorage resourcePacksStorage = (ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class);
            if (resourcePacksStorage.hasFinishedLoading()) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACK_CHUNK_DATA after loading completion");
                return;
            }
            Pair idAndVersion = (Pair)wrapper.read(BedrockTypes.PACK_ID_AND_VERSION);
            int chunkIndex = (Integer)wrapper.read((Type)BedrockTypes.INT_LE);
            wrapper.read((Type)BedrockTypes.LONG_LE);
            byte[] data = (byte[])wrapper.read(BedrockTypes.BYTE_ARRAY);
            if (resourcePacksStorage.hasPack((UUID)idAndVersion.key()) && !resourcePacksStorage.getPack((UUID)idAndVersion.key()).isDecompressed()) {
                ResourcePack resourcePack = resourcePacksStorage.getPack((UUID)idAndVersion.key());
                try {
                    if (!resourcePack.processDataChunk(chunkIndex, data)) return;
                    ((ResourcePackProvider)Via.getManager().getProviders().get(ResourcePackProvider.class)).addPack(resourcePack);
                    resourcePacksStorage.sendResponseIfAllDownloadsCompleted();
                    return;
                }
                catch (Throwable e) {
                    throw new RuntimeException("Failed to process RESOURCE_PACK_CHUNK_DATA for pack: " + String.valueOf(idAndVersion.key()), e);
                }
            } else {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACK_CHUNK_DATA for unknown pack: " + String.valueOf(idAndVersion.key()));
            }
        });
        protocol.registerClientbound(ClientboundBedrockPackets.RESOURCE_PACK_STACK, null, wrapper -> {
            wrapper.cancel();
            ResourcePacksStorage resourcePacksStorage = (ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class);
            if (resourcePacksStorage.hasFinishedLoading()) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received RESOURCE_PACK_STACK after loading completion");
                return;
            }
            wrapper.read((Type)Types.BOOLEAN);
            Triple[] behaviourPacks = (Triple[])wrapper.read(BedrockTypes.PACK_ID_AND_VERSION_AND_NAME_ARRAY);
            Triple[] resourcePacks = (Triple[])wrapper.read(BedrockTypes.PACK_ID_AND_VERSION_AND_NAME_ARRAY);
            wrapper.read(BedrockTypes.STRING);
            Experiment[] experiments = (Experiment[])wrapper.read(BedrockTypes.EXPERIMENT_ARRAY);
            wrapper.read((Type)Types.BOOLEAN);
            wrapper.read((Type)Types.BOOLEAN);
            for (Experiment experiment : experiments) {
                if (!experiment.enabled()) continue;
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "This server uses an experimental resource pack: " + experiment.name());
            }
            UUID[] behaviourPackIds = new UUID[behaviourPacks.length];
            for (int i = 0; i < behaviourPacks.length; ++i) {
                behaviourPackIds[i] = (UUID)behaviourPacks[i].first();
            }
            UUID[] resourcePackIds = new UUID[resourcePacks.length];
            for (int i = 0; i < resourcePacks.length; ++i) {
                resourcePackIds[i] = (UUID)resourcePacks[i].first();
            }
            resourcePacksStorage.setPackStack(resourcePackIds, behaviourPackIds);
            if (!resourcePacksStorage.isJavaClientWaitingForPack()) {
                PacketWrapper resourcePackClientResponse = wrapper.create((PacketType)ServerboundBedrockPackets.RESOURCE_PACK_CLIENT_RESPONSE);
                resourcePackClientResponse.write((Type)Types.BYTE, (Object)((byte)ResourcePackResponse.ResourcePackStackFinished.getValue()));
                resourcePackClientResponse.write(BedrockTypes.SHORT_LE_STRING_ARRAY, (Object)new String[0]);
                resourcePackClientResponse.sendToServer(BedrockProtocol.class);
            }
        });
        protocol.registerServerboundTransition((ServerboundPacketType)ServerboundConfigurationPackets1_21_9.RESOURCE_PACK, ServerboundBedrockPackets.RESOURCE_PACK_CLIENT_RESPONSE, wrapper -> {
            ResourcePacksStorage resourcePacksStorage = (ResourcePacksStorage)wrapper.user().get(ResourcePacksStorage.class);
            wrapper.read(Types.UUID);
            ResourcePackAction status = ResourcePackAction.values()[(Integer)wrapper.read((Type)Types.VAR_INT)];
            switch (status) {
                case SUCCESSFULLY_LOADED: {
                    if (!resourcePacksStorage.hasFinishedLoading()) {
                        wrapper.cancel();
                    }
                    resourcePacksStorage.setLoadedOnJavaClient();
                    wrapper.write((Type)Types.BYTE, (Object)((byte)ResourcePackResponse.ResourcePackStackFinished.getValue()));
                    wrapper.write(BedrockTypes.SHORT_LE_STRING_ARRAY, (Object)new String[0]);
                    break;
                }
                case FAILED_DOWNLOAD: 
                case INVALID_URL: 
                case FAILED_RELOAD: 
                case DISCARDED: {
                    if (!resourcePacksStorage.hasFinishedLoading()) {
                        wrapper.cancel();
                    }
                    resourcePacksStorage.setJavaClientWaitingForPack(false);
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Client resource pack download/loading failed");
                    wrapper.write((Type)Types.BYTE, (Object)((byte)ResourcePackResponse.ResourcePackStackFinished.getValue()));
                    wrapper.write(BedrockTypes.SHORT_LE_STRING_ARRAY, (Object)new String[0]);
                    break;
                }
                case DECLINED: {
                    wrapper.user().put((StorableObject)new ResourcePacksStorage(wrapper.user()));
                    wrapper.write((Type)Types.BYTE, (Object)((byte)ResourcePackResponse.DownloadingFinished.getValue()));
                    wrapper.write(BedrockTypes.SHORT_LE_STRING_ARRAY, (Object)new String[0]);
                    break;
                }
                case ACCEPTED: {
                    resourcePacksStorage.setJavaClientWaitingForPack(true);
                    HashSet<CallSite> missingNonHttpPacks = new HashSet<CallSite>();
                    ArrayList<ResourcePack> missingHttpPacks = new ArrayList<ResourcePack>();
                    for (ResourcePack pack2 : resourcePacksStorage.getPacks()) {
                        try {
                            if (((ResourcePackProvider)Via.getManager().getProviders().get(ResourcePackProvider.class)).hasPack(pack2)) {
                                ((ResourcePackProvider)Via.getManager().getProviders().get(ResourcePackProvider.class)).loadPack(pack2);
                                continue;
                            }
                            if (pack2.cdnUrl() != null) {
                                missingHttpPacks.add(pack2);
                                continue;
                            }
                            missingNonHttpPacks.add((CallSite)((Object)(String.valueOf(pack2.packId()) + "_" + pack2.version())));
                        }
                        catch (Throwable e2) {
                            throw new RuntimeException("Failed to load resource pack: " + String.valueOf(pack2.packId()), e2);
                        }
                    }
                    if (missingNonHttpPacks.isEmpty() && missingHttpPacks.isEmpty()) {
                        wrapper.write((Type)Types.BYTE, (Object)((byte)ResourcePackResponse.DownloadingFinished.getValue()));
                        wrapper.write(BedrockTypes.SHORT_LE_STRING_ARRAY, (Object)new String[0]);
                        break;
                    }
                    if (!missingHttpPacks.isEmpty()) {
                        if (missingNonHttpPacks.isEmpty()) {
                            wrapper.cancel();
                        }
                        ViaBedrock.getPlatform().getLogger().log(Level.INFO, "Downloading " + missingHttpPacks.size() + " HTTP packs");
                        resourcePacksStorage.runHttpTask(missingHttpPacks, pack -> {
                            BedrockPackDownloader downloader = new BedrockPackDownloader(pack.cdnUrl());
                            byte[] data = downloader.download();
                            pack.setCompressedDataLength(data.length, data.length);
                            wrapper.user().getChannel().eventLoop().submit(() -> {
                                try {
                                    if (pack.processDataChunk(0, data)) {
                                        ((ResourcePackProvider)Via.getManager().getProviders().get(ResourcePackProvider.class)).addPack((ResourcePack)pack);
                                        resourcePacksStorage.sendResponseIfAllDownloadsCompleted();
                                    }
                                }
                                catch (Throwable e) {
                                    BedrockProtocol.kickForIllegalState(wrapper.user(), "One of the server resource packs failed to process. Please try again later or decline the packs.", e);
                                }
                            });
                        }, (pack, e) -> BedrockProtocol.kickForIllegalState(wrapper.user(), "One of the server resource packs failed to download. Please try again later or decline the packs.", e));
                    }
                    if (missingNonHttpPacks.isEmpty()) break;
                    ViaBedrock.getPlatform().getLogger().log(Level.INFO, "Downloading " + missingNonHttpPacks.size() + " non HTTP packs");
                    wrapper.write((Type)Types.BYTE, (Object)((byte)ResourcePackResponse.Downloading.getValue()));
                    wrapper.write(BedrockTypes.SHORT_LE_STRING_ARRAY, (Object)missingNonHttpPacks.toArray(new String[0]));
                    break;
                }
                case DOWNLOADED: {
                    wrapper.cancel();
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled ResourcePackAction: " + String.valueOf((Object)status));
                }
            }
        });
    }
}

