/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.viaversion.nbt.tag.ByteTag;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntOpenHashMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;
import com.viaversion.viaversion.libs.fastutil.ints.IntLinkedOpenHashSet;
import com.viaversion.viaversion.libs.fastutil.ints.IntSortedSet;
import com.viaversion.viaversion.libs.fastutil.objects.Object2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.objects.Object2ObjectOpenHashMap;
import com.viaversion.viaversion.util.Key;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.chunk.blockstate.BlockStateSanitizer;
import net.raphimc.viabedrock.api.model.BedrockBlockState;
import net.raphimc.viabedrock.api.model.BlockState;
import net.raphimc.viabedrock.api.util.BlockStateHasher;
import net.raphimc.viabedrock.api.util.CombinationUtil;
import net.raphimc.viabedrock.api.util.HashedPaletteComparator;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.model.BlockProperties;

public class BlockStateRewriter
implements StorableObject {
    public static final String TAG_WATER = "water";
    public static final String TAG_ITEM_FRAME = "item_frame";
    public static final String TAG_SIGN = "sign";
    public static final String TAG_HANGING_SIGN = "hanging_sign";
    private final Int2IntMap blockStateIdMappings = new Int2IntOpenHashMap();
    private final Int2IntMap legacyBlockStateIdMappings = new Int2IntOpenHashMap();
    private final BiMap<BlockState, Integer> blockStateMappings = HashBiMap.create();
    private final Object2ObjectMap<String, IntSortedSet> validBlockStates = new Object2ObjectOpenHashMap();
    private final Int2ObjectMap<String> blockStateTags = new Int2ObjectOpenHashMap();
    private final BlockStateSanitizer blockStateSanitizer;

    public BlockStateRewriter(BlockProperties[] blockProperties, boolean hashedRuntimeBlockIds) {
        this.blockStateIdMappings.defaultReturnValue(-1);
        this.legacyBlockStateIdMappings.defaultReturnValue(-1);
        ArrayList<BedrockBlockState> bedrockBlockStates = new ArrayList<BedrockBlockState>(BedrockProtocol.MAPPINGS.getBedrockBlockStates());
        BiMap<BlockState, Integer> javaBlockStates = BedrockProtocol.MAPPINGS.getJavaBlockStates();
        Map<BlockState, BlockState> bedrockToJavaBlockStates = BedrockProtocol.MAPPINGS.getBedrockToJavaBlockStates();
        Map<String, String> blockTags = BedrockProtocol.MAPPINGS.getBedrockBlockTags();
        Set bedrockBlockIdentifiers = bedrockBlockStates.stream().map(BlockState::namespacedIdentifier).collect(Collectors.toSet());
        ArrayList<BedrockBlockState> customBlockStates = new ArrayList<BedrockBlockState>();
        HashMap<String, CompoundTag> effectiveBlockProperties = new HashMap<String, CompoundTag>();
        for (BlockProperties blockProperty : blockProperties) {
            String identifier = blockProperty.name().toLowerCase(Locale.ROOT);
            if (bedrockBlockIdentifiers.contains(identifier) || effectiveBlockProperties.containsKey(identifier)) continue;
            effectiveBlockProperties.put(identifier, blockProperty.properties());
        }
        for (Map.Entry entry : effectiveBlockProperties.entrySet()) {
            List combinations;
            ListTag traits;
            Tag enumTag;
            if (!(((CompoundTag)entry.getValue()).get("vanilla_block_data") instanceof CompoundTag)) continue;
            if (!(((CompoundTag)entry.getValue()).get("menu_category") instanceof CompoundTag)) {
                throw new IllegalStateException("Missing menu_category tag for " + (String)entry.getKey());
            }
            LinkedHashMap propertiesMap = new LinkedHashMap();
            ListTag properties = ((CompoundTag)entry.getValue()).getListTag("properties", CompoundTag.class);
            if (properties != null) {
                for (Object property : properties) {
                    Tag tag = property.get("name");
                    if (!(tag instanceof StringTag)) continue;
                    StringTag nameTag = (StringTag)tag;
                    String name = nameTag.getValue();
                    Tag tag2 = property.get("enum");
                    if (!(tag2 instanceof ListTag)) continue;
                    enumTag = (ListTag)tag2;
                    LinkedHashSet<Tag> values = new LinkedHashSet<Tag>();
                    for (Tag tag3 : enumTag) {
                        values.add(tag3);
                    }
                    propertiesMap.put(name, values);
                }
            }
            if ((traits = ((CompoundTag)entry.getValue()).getListTag("traits", CompoundTag.class)) != null) {
                Object property;
                property = traits.iterator();
                while (property.hasNext()) {
                    CompoundTag trait = (CompoundTag)property.next();
                    enumTag = trait.get("name");
                    if (!(enumTag instanceof StringTag)) continue;
                    StringTag nameTag = (StringTag)enumTag;
                    String name = Key.namespaced((String)nameTag.getValue());
                    Map<String, Set<String>> traitStates = BedrockProtocol.MAPPINGS.getBedrockBlockTraits().get(name);
                    if (traitStates == null) {
                        throw new RuntimeException("Missing block trait states for " + name);
                    }
                    Tag tag = trait.get("enabled_states");
                    if (tag instanceof CompoundTag) {
                        CompoundTag enabledStatesTag = (CompoundTag)tag;
                        if (enabledStatesTag.size() != traitStates.size()) {
                            throw new RuntimeException("Invalid enabled_states tag for trait " + name + " (size mismatch)");
                        }
                        for (Map.Entry tag4 : enabledStatesTag) {
                            String key = Key.namespaced((String)((String)tag4.getKey()));
                            boolean enabled = tag4.getValue() instanceof ByteTag && ((ByteTag)tag4.getValue()).asByte() != 0;
                            if (!enabled) continue;
                            if (traitStates.containsKey(key)) {
                                Set<String> states = traitStates.get(key);
                                LinkedHashSet<StringTag> values = new LinkedHashSet<StringTag>();
                                for (String state : states) {
                                    values.add(new StringTag(state));
                                }
                                propertiesMap.put(key, values);
                                continue;
                            }
                            throw new RuntimeException("Missing block trait states for trait " + name + " and key " + key);
                        }
                        continue;
                    }
                    throw new RuntimeException("Missing enabled_states tag for trait " + name);
                }
            }
            if ((combinations = CombinationUtil.generateCombinations(propertiesMap).stream().map(stringTagMap -> {
                CompoundTag combination = new CompoundTag();
                for (Map.Entry entry : stringTagMap.entrySet()) {
                    combination.put((String)entry.getKey(), ((Tag)entry.getValue()).copy());
                }
                return combination;
            }).collect(Collectors.toList())).isEmpty()) {
                combinations.add(new CompoundTag());
            }
            for (CompoundTag combination : combinations) {
                CompoundTag blockStateTag = new CompoundTag();
                blockStateTag.putString("name", (String)entry.getKey());
                blockStateTag.put("states", (Tag)combination);
                blockStateTag.putInt("network_id", BlockStateHasher.hash(blockStateTag));
                customBlockStates.add(BedrockBlockState.fromNbt(blockStateTag));
            }
        }
        bedrockBlockStates.addAll(customBlockStates);
        bedrockBlockStates.sort((a, b) -> HashedPaletteComparator.INSTANCE.compare(a.namespacedIdentifier(), b.namespacedIdentifier()));
        for (int i = 0; i < bedrockBlockStates.size(); ++i) {
            int javaId;
            int bedrockId;
            BedrockBlockState bedrockBlockState = (BedrockBlockState)bedrockBlockStates.get(i);
            int n = bedrockId = hashedRuntimeBlockIds ? bedrockBlockState.blockStateTag().getIntTag("network_id").asInt() : i;
            if (hashedRuntimeBlockIds && this.blockStateMappings.containsValue((Object)bedrockId)) {
                ++bedrockId;
            }
            this.blockStateMappings.put((Object)bedrockBlockState, (Object)bedrockId);
            ((IntSortedSet)this.validBlockStates.computeIfAbsent((Object)bedrockBlockState.namespacedIdentifier(), k -> new IntLinkedOpenHashSet())).add(bedrockId);
            if (blockTags.containsKey(bedrockBlockState.namespacedIdentifier())) {
                this.blockStateTags.put(bedrockId, (Object)blockTags.get(bedrockBlockState.namespacedIdentifier()));
            }
            if (bedrockToJavaBlockStates.containsKey(bedrockBlockState)) {
                javaId = (Integer)javaBlockStates.get(bedrockToJavaBlockStates.get(bedrockBlockState));
                this.blockStateIdMappings.put(bedrockId, javaId);
                continue;
            }
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Missing bedrock -> java block state mapping: " + bedrockBlockState.toBlockStateString());
            javaId = (Integer)javaBlockStates.get(bedrockToJavaBlockStates.get(BedrockBlockState.INFO_UPDATE));
            this.blockStateIdMappings.put(bedrockId, javaId);
        }
        for (Int2ObjectMap.Entry entry : BedrockProtocol.MAPPINGS.getBedrockLegacyBlockStates().int2ObjectEntrySet()) {
            int legacyId = entry.getIntKey() >> 6;
            int legacyData = entry.getIntKey() & 0x3F;
            if (legacyData > 15) continue;
            this.legacyBlockStateIdMappings.put(legacyId << 4 | legacyData & 0xF, ((Integer)this.blockStateMappings.getOrDefault(entry.getValue(), (Object)-1)).intValue());
        }
        this.blockStateSanitizer = new BlockStateSanitizer(bedrockBlockStates);
    }

    public int bedrockId(CompoundTag bedrockBlockStateTag) {
        CompoundTag bedrockBlockStateTagClone = bedrockBlockStateTag.copy();
        try {
            BedrockProtocol.MAPPINGS.getBedrockBlockStateUpgrader().upgradeToLatest(bedrockBlockStateTagClone);
            this.blockStateSanitizer.sanitize(bedrockBlockStateTagClone);
            return this.bedrockId(BedrockBlockState.fromNbt(bedrockBlockStateTagClone));
        }
        catch (Throwable e) {
            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Error while rewriting block state tag: " + String.valueOf(bedrockBlockStateTag), e);
            return this.bedrockId(BedrockBlockState.AIR);
        }
    }

    public int bedrockId(BlockState bedrockBlockState) {
        return (Integer)this.blockStateMappings.getOrDefault((Object)bedrockBlockState, (Object)-1);
    }

    public BlockState blockState(int bedrockBlockStateId) {
        return (BlockState)this.blockStateMappings.inverse().get((Object)bedrockBlockStateId);
    }

    public int bedrockId(int legacyBlockStateId) {
        return this.legacyBlockStateIdMappings.get(legacyBlockStateId);
    }

    public int javaId(int bedrockBlockStateId) {
        return this.blockStateIdMappings.get(bedrockBlockStateId);
    }

    public int waterlog(int javaBlockStateId) {
        if (BedrockProtocol.MAPPINGS.getJavaPreWaterloggedBlockStates().contains(javaBlockStateId)) {
            return javaBlockStateId;
        }
        BlockState waterlogged = ((BlockState)BedrockProtocol.MAPPINGS.getJavaBlockStates().inverse().get((Object)javaBlockStateId)).withProperty("waterlogged", "true");
        return (Integer)BedrockProtocol.MAPPINGS.getJavaBlockStates().getOrDefault((Object)waterlogged, (Object)-1);
    }

    public IntSortedSet validBlockStates(String bedrockBlockIdentifier) {
        return (IntSortedSet)this.validBlockStates.get((Object)bedrockBlockIdentifier);
    }

    public String tag(int bedrockBlockStateId) {
        return (String)this.blockStateTags.get(bedrockBlockStateId);
    }
}

