/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.blockentity;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.IntTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntityImpl;
import java.util.Collections;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.chunk.BedrockBlockEntity;
import net.raphimc.viabedrock.api.chunk.BlockEntityWithBlockState;
import net.raphimc.viabedrock.api.model.BlockState;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.enums.DyeColor;
import net.raphimc.viabedrock.protocol.rewriter.BlockEntityRewriter;
import net.raphimc.viabedrock.protocol.storage.ChunkTracker;

public class BannerBlockEntityRewriter
implements BlockEntityRewriter.Rewriter {
    @Override
    public BlockEntity toJava(UserConnection user, BedrockBlockEntity bedrockBlockEntity) {
        IntTag baseTag;
        Tag bedrockPattern2;
        ListTag bedrockPatterns;
        IntTag typeTag;
        int type;
        CompoundTag bedrockTag = bedrockBlockEntity.tag();
        CompoundTag javaTag = new CompoundTag();
        Tag tag = bedrockTag.get("Type");
        if (tag instanceof IntTag && (type = (typeTag = (IntTag)tag).asInt()) == 1) {
            bedrockTag.putInt("Base", (int)DyeColor.WHITE.bedrockId());
            Iterator patterns = new ListTag(CompoundTag.class);
            patterns.add((Tag)this.createBedrockPattern("mr", DyeColor.CYAN));
            patterns.add((Tag)this.createBedrockPattern("bs", DyeColor.LIGHT_GRAY));
            patterns.add((Tag)this.createBedrockPattern("cs", DyeColor.GRAY));
            patterns.add((Tag)this.createBedrockPattern("bo", DyeColor.LIGHT_GRAY));
            patterns.add((Tag)this.createBedrockPattern("ms", DyeColor.BLACK));
            patterns.add((Tag)this.createBedrockPattern("hh", DyeColor.LIGHT_GRAY));
            patterns.add((Tag)this.createBedrockPattern("mc", DyeColor.LIGHT_GRAY));
            patterns.add((Tag)this.createBedrockPattern("bo", DyeColor.BLACK));
            bedrockTag.put("Patterns", (Tag)patterns);
        }
        if ((bedrockPatterns = bedrockTag.getListTag("Patterns", CompoundTag.class)) != null) {
            ListTag javaPatterns = new ListTag(CompoundTag.class);
            for (Tag bedrockPattern2 : bedrockPatterns) {
                Tag tag2 = bedrockPattern2.get("Pattern");
                if (!(tag2 instanceof StringTag)) continue;
                StringTag patternTag = (StringTag)tag2;
                String pattern = patternTag.getValue();
                DyeColor color = DyeColor.getByBedrockId(bedrockPattern2.getInt("Color", (int)DyeColor.BLACK.bedrockId()), DyeColor.PURPLE);
                String javaPattern = (String)BedrockProtocol.MAPPINGS.getBedrockToJavaBannerPatterns().get((Object)pattern);
                if (javaPattern != null) {
                    javaPatterns.add((Tag)this.createJavaPattern(javaPattern, color));
                    continue;
                }
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown bedrock banner pattern: " + pattern);
            }
            javaTag.put("patterns", (Tag)javaPatterns);
        }
        int javaBlockState = ((ChunkTracker)user.get(ChunkTracker.class)).getJavaBlockState(bedrockBlockEntity.position());
        bedrockPattern2 = bedrockTag.get("Base");
        if (bedrockPattern2 instanceof IntTag && (baseTag = (IntTag)bedrockPattern2).asInt() != DyeColor.BLACK.bedrockId()) {
            DyeColor baseColor = DyeColor.getByBedrockId(baseTag.asInt(), DyeColor.PURPLE);
            boolean isStandingBanner = ((BlockState)BedrockProtocol.MAPPINGS.getJavaBlockStates().inverse().get((Object)javaBlockState)).identifier().equals("black_banner");
            javaBlockState -= baseColor.bedrockId() * (isStandingBanner ? 16 : 4);
        }
        return new BlockEntityWithBlockState((BlockEntity)new BlockEntityImpl(bedrockBlockEntity.packedXZ(), bedrockBlockEntity.y(), -1, javaTag), javaBlockState);
    }

    private CompoundTag createJavaPattern(String pattern, DyeColor color) {
        CompoundTag patternTag = new CompoundTag();
        patternTag.putString("pattern", pattern);
        patternTag.putString("color", color.name().toLowerCase(Locale.ROOT));
        return patternTag;
    }

    private CompoundTag createBedrockPattern(String pattern, DyeColor color) {
        CompoundTag patternTag = new CompoundTag();
        patternTag.putString("Pattern", pattern);
        patternTag.putInt("Color", (int)color.bedrockId());
        return patternTag;
    }

    static {
        BlockState blockState = new BlockState("black_banner", Collections.singletonMap("rotation", "0"));
        if (!BedrockProtocol.MAPPINGS.getJavaBlockStates().containsKey((Object)blockState)) {
            throw new IllegalStateException("Unable to find black banner block state with rotation 0");
        }
    }
}

