/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.blockentity;

import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.IntTag;
import com.viaversion.nbt.tag.ShortTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntityImpl;
import com.viaversion.viaversion.api.minecraft.entities.EntityTypes1_21_9;
import com.viaversion.viaversion.util.Key;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.chunk.BedrockBlockEntity;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.rewriter.BlockEntityRewriter;

public class MobSpawnerBlockEntityRewriter
implements BlockEntityRewriter.Rewriter {
    @Override
    public BlockEntity toJava(UserConnection user, BedrockBlockEntity bedrockBlockEntity) {
        Tag bedrockEntityId2;
        CompoundTag bedrockTag = bedrockBlockEntity.tag();
        CompoundTag javaTag = new CompoundTag();
        this.copy(bedrockTag, javaTag, "Delay", ShortTag.class);
        this.copy(bedrockTag, javaTag, "MinSpawnDelay", ShortTag.class);
        this.copy(bedrockTag, javaTag, "MaxSpawnDelay", ShortTag.class);
        this.copy(bedrockTag, javaTag, "SpawnCount", ShortTag.class);
        this.copy(bedrockTag, javaTag, "MaxNearbyEntities", ShortTag.class);
        this.copy(bedrockTag, javaTag, "RequiredPlayerRange", ShortTag.class);
        this.copy(bedrockTag, javaTag, "SpawnRange", ShortTag.class);
        Tag tag = bedrockTag.get("EntityId");
        if (tag instanceof IntTag) {
            IntTag entityIdTag = (IntTag)tag;
            int bedrockEntityId2 = entityIdTag.asInt();
            String bedrockEntityIdentifier = (String)BedrockProtocol.MAPPINGS.getBedrockEntities().inverse().getOrDefault((Object)bedrockEntityId2, (Object)("viabedrock:" + bedrockEntityId2));
            bedrockTag.putString("EntityIdentifier", bedrockEntityIdentifier);
        }
        if ((bedrockEntityId2 = bedrockTag.get("EntityIdentifier")) instanceof StringTag) {
            StringTag entityIdentifierTag = (StringTag)bedrockEntityId2;
            String bedrockEntityIdentifier = entityIdentifierTag.getValue();
            EntityTypes1_21_9 javaEntityType = BedrockProtocol.MAPPINGS.getBedrockToJavaEntities().get(Key.namespaced((String)bedrockEntityIdentifier));
            if (javaEntityType != null) {
                CompoundTag spawnData = new CompoundTag();
                CompoundTag entityTag = new CompoundTag();
                entityTag.putString("id", javaEntityType.identifier());
                spawnData.put("entity", (Tag)entityTag);
                javaTag.put("SpawnData", (Tag)spawnData);
            } else if (!Key.stripNamespace((String)bedrockEntityIdentifier).isEmpty()) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unknown bedrock entity identifier: " + bedrockEntityIdentifier);
                CompoundTag spawnData = new CompoundTag();
                spawnData.put("entity", (Tag)new CompoundTag());
                javaTag.put("SpawnData", (Tag)spawnData);
            }
        }
        return new BlockEntityImpl(bedrockBlockEntity.packedXZ(), bedrockBlockEntity.y(), -1, javaTag);
    }
}

