/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.blockentity;

import com.viaversion.nbt.tag.ByteTag;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.FloatTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntityImpl;
import com.viaversion.viaversion.libs.fastutil.ints.IntOpenHashSet;
import com.viaversion.viaversion.libs.fastutil.ints.IntSet;
import net.raphimc.viabedrock.api.chunk.BedrockBlockEntity;
import net.raphimc.viabedrock.api.chunk.BlockEntityWithBlockState;
import net.raphimc.viabedrock.api.model.BedrockBlockState;
import net.raphimc.viabedrock.api.model.BlockState;
import net.raphimc.viabedrock.api.util.MathUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.rewriter.BlockEntityRewriter;
import net.raphimc.viabedrock.protocol.storage.ChunkTracker;

public class SkullBlockEntityRewriter
implements BlockEntityRewriter.Rewriter {
    private static final IntSet SKULLS_WITH_ROTATION_UPDATE = new IntOpenHashSet();

    @Override
    public BlockEntity toJava(UserConnection user, BedrockBlockEntity bedrockBlockEntity) {
        CompoundTag bedrockTag = bedrockBlockEntity.tag();
        int javaBlockState = ((ChunkTracker)user.get(ChunkTracker.class)).getJavaBlockState(bedrockBlockEntity.position());
        if (SKULLS_WITH_ROTATION_UPDATE.contains(javaBlockState)) {
            Tag tag = bedrockTag.get("Rot");
            if (tag instanceof ByteTag) {
                ByteTag rotTag = (ByteTag)tag;
                javaBlockState += this.convertRot(rotTag.asByte());
            } else {
                tag = bedrockTag.get("Rotation");
                if (tag instanceof FloatTag) {
                    FloatTag rotationTag = (FloatTag)tag;
                    javaBlockState += this.convertRotation(rotationTag.asFloat());
                }
            }
        }
        return new BlockEntityWithBlockState((BlockEntity)new BlockEntityImpl(bedrockBlockEntity.packedXZ(), bedrockBlockEntity.y(), -1, new CompoundTag()), javaBlockState);
    }

    private int convertRot(byte b) {
        if ((b = (byte)(b % 16)) < 0) {
            b = (byte)(b + 16);
        }
        return b;
    }

    private int convertRotation(float f) {
        if ((f %= 360.0f) < 0.0f) {
            f += 360.0f;
        }
        return MathUtil.ceil(f / 360.0f * 15.0f);
    }

    static {
        for (BedrockBlockState bedrockBlockState : BedrockProtocol.MAPPINGS.getBedrockBlockStates()) {
            if (!"skull".equals(BedrockProtocol.MAPPINGS.getBedrockBlockTags().get(bedrockBlockState.namespacedIdentifier()))) continue;
            BlockState javaBlockState = BedrockProtocol.MAPPINGS.getBedrockToJavaBlockStates().get(bedrockBlockState);
            if (!bedrockBlockState.properties().get("facing_direction").equals("1") || !javaBlockState.properties().get("rotation").equals("0")) continue;
            int id = (Integer)BedrockProtocol.MAPPINGS.getJavaBlockStates().getOrDefault((Object)javaBlockState, (Object)-1);
            if (id == -1) {
                throw new IllegalStateException("Unable to find " + javaBlockState.toBlockStateString());
            }
            SKULLS_WITH_ROTATION_UPDATE.add(id);
        }
        if (SKULLS_WITH_ROTATION_UPDATE.isEmpty()) {
            throw new IllegalStateException("Unable to find any rotatable skulls");
        }
    }
}

