/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBufUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.provider.BlobCacheProvider;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class BlobCache
extends StoredObject {
    private static final XXHash64 XXHASH64 = XXHashFactory.fastestInstance().hash64();
    private final Map<Long, CompletableFuture<byte[]>> pending = new HashMap<Long, CompletableFuture<byte[]>>();
    private final List<Long> missing = new ArrayList<Long>();
    private final List<Long> acked = new ArrayList<Long>();

    public BlobCache(UserConnection user) {
        super(user);
    }

    public void tick() {
        if (this.missing.isEmpty() && this.acked.isEmpty()) {
            return;
        }
        List<Long> missingSubSet = this.missing.subList(0, Math.min(1024, this.missing.size()));
        List<Long> ackedSubSet = this.acked.subList(0, Math.min(1024, this.acked.size()));
        PacketWrapper clientCacheBlobStatus = PacketWrapper.create((PacketType)ServerboundBedrockPackets.CLIENT_CACHE_BLOB_STATUS, (UserConnection)this.user());
        clientCacheBlobStatus.write((Type)BedrockTypes.UNSIGNED_VAR_INT, (Object)missingSubSet.size());
        clientCacheBlobStatus.write((Type)BedrockTypes.UNSIGNED_VAR_INT, (Object)ackedSubSet.size());
        for (long hash : missingSubSet) {
            clientCacheBlobStatus.write((Type)BedrockTypes.LONG_LE, (Object)hash);
        }
        for (long hash : ackedSubSet) {
            clientCacheBlobStatus.write((Type)BedrockTypes.LONG_LE, (Object)hash);
        }
        clientCacheBlobStatus.sendToServer(BedrockProtocol.class);
        this.missing.removeAll(missingSubSet);
        this.acked.removeAll(ackedSubSet);
    }

    public void addBlob(long hash, byte[] blob) {
        if (!this.pending.containsKey(hash)) {
            throw new IllegalStateException("Received unexpected blob: " + hash + " (" + ByteBufUtil.hexDump((byte[])blob) + ")");
        }
        long expectedHash = XXHASH64.hash(blob, 0, blob.length, 0L);
        if (hash != expectedHash) {
            throw new IllegalStateException("Received blob with unexpected hash: " + hash + " != " + expectedHash + " (" + ByteBufUtil.hexDump((byte[])blob) + ")");
        }
        ((BlobCacheProvider)Via.getManager().getProviders().get(BlobCacheProvider.class)).addBlob(hash, blob);
        this.acked.add(hash);
        this.pending.remove(hash).complete(blob);
    }

    public boolean hasBlob(long ... hashes) {
        for (long hash : hashes) {
            if (((BlobCacheProvider)Via.getManager().getProviders().get(BlobCacheProvider.class)).hasBlob(hash)) continue;
            return false;
        }
        return true;
    }

    public CompletableFuture<byte[]> getBlob(long ... hashes) {
        return this.getBlob(true, hashes);
    }

    public CompletableFuture<byte[]> getBlob(Long[] hashes) {
        long[] longs = new long[hashes.length];
        for (int i = 0; i < hashes.length; ++i) {
            longs[i] = hashes[i];
        }
        return this.getBlob(true, longs);
    }

    public CompletableFuture<byte[]> getBlob(boolean acknowledge, long ... hashes) {
        if (acknowledge) {
            for (long hash : hashes) {
                if (this.hasBlob(hash)) {
                    this.acked.add(hash);
                    continue;
                }
                if (this.pending.containsKey(hash)) continue;
                this.missing.add(hash);
            }
        }
        if (this.hasBlob(hashes)) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            try {
                for (long hash : hashes) {
                    output.write(((BlobCacheProvider)Via.getManager().getProviders().get(BlobCacheProvider.class)).getBlob(hash));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return CompletableFuture.completedFuture(output.toByteArray());
        }
        CompletableFuture<byte[]> rootFuture = new CompletableFuture<byte[]>();
        for (long hash : hashes) {
            if (this.hasBlob(hash)) continue;
            CompletableFuture subFuture = new CompletableFuture();
            CompletableFuture<byte[]> existing = this.pending.get(hash);
            if (existing != null) {
                subFuture.whenComplete((blob, throwable) -> {
                    if (throwable != null) {
                        existing.completeExceptionally((Throwable)throwable);
                    } else {
                        existing.complete((byte[])blob);
                    }
                });
            }
            subFuture.whenComplete((blob, throwable) -> {
                if (throwable != null) {
                    rootFuture.completeExceptionally((Throwable)throwable);
                } else if (this.hasBlob(hashes)) {
                    rootFuture.complete(this.getBlob(false, hashes).getNow(null));
                }
            });
            this.pending.put(hash, subFuture);
        }
        return rootFuture;
    }
}

