/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock;

import com.viaversion.viaversion.util.Config;
import java.io.File;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.raphimc.viabedrock.platform.ViaBedrockConfig;

public class ViaBedrockConfig
extends Config
implements net.raphimc.viabedrock.platform.ViaBedrockConfig {
    private boolean enableExperimentalFeatures;
    private ViaBedrockConfig.BlobCacheMode blobCacheMode;
    private boolean translateResourcePacks;
    private String resourcePackHost;
    private int resourcePackPort;
    private String resourcePackUrl;
    private ViaBedrockConfig.PackCacheMode packCacheMode;
    private boolean translateShowCoordinatesGameRule;
    private boolean disableServerBlacklist;

    public ViaBedrockConfig(File configFile, Logger logger) {
        super(configFile, logger);
    }

    public void reload() {
        super.reload();
        this.loadFields();
    }

    private void loadFields() {
        this.enableExperimentalFeatures = this.getBoolean("enable-experimental-features", false);
        this.blobCacheMode = ViaBedrockConfig.BlobCacheMode.byName(this.getString("blob-cache", "disk"));
        this.translateResourcePacks = this.getBoolean("translate-resource-packs", true);
        this.resourcePackHost = this.getString("resource-pack-host", "127.0.0.1");
        this.resourcePackPort = this.getInt("resource-pack-port", 0);
        this.resourcePackUrl = this.getString("resource-pack-url", "");
        this.packCacheMode = ViaBedrockConfig.PackCacheMode.byName(this.getString("pack-cache", "disk"));
        this.translateShowCoordinatesGameRule = this.getBoolean("translate-show-coordinates-game-rule", false);
        this.disableServerBlacklist = this.getBoolean("disable-server-blacklist", false);
    }

    public URL getDefaultConfigURL() {
        return this.getClass().getClassLoader().getResource("assets/viabedrock/viabedrock.yml");
    }

    protected void handleConfig(Map<String, Object> map) {
    }

    @Override
    public boolean shouldEnableExperimentalFeatures() {
        return this.enableExperimentalFeatures;
    }

    public List<String> getUnsupportedOptions() {
        return Collections.emptyList();
    }

    @Override
    public ViaBedrockConfig.BlobCacheMode getBlobCacheMode() {
        return this.blobCacheMode;
    }

    @Override
    public boolean shouldTranslateResourcePacks() {
        return this.translateResourcePacks;
    }

    @Override
    public String getResourcePackHost() {
        return this.resourcePackHost;
    }

    @Override
    public int getResourcePackPort() {
        return this.resourcePackPort;
    }

    @Override
    public String getResourcePackUrl() {
        return this.resourcePackUrl;
    }

    @Override
    public ViaBedrockConfig.PackCacheMode getPackCacheMode() {
        return this.packCacheMode;
    }

    @Override
    public boolean shouldTranslateShowCoordinatesGameRule() {
        return this.translateShowCoordinatesGameRule;
    }

    @Override
    public boolean shouldDisableServerBlacklist() {
        return this.disableServerBlacklist;
    }
}

