/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.chunk.datapalette;

import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.NibbleArray;

public class BedrockBlockArray
implements DataPalette,
Cloneable {
    private byte[] blocks;
    private NibbleArray data;

    public BedrockBlockArray() {
        this.blocks = new byte[4096];
        this.data = new NibbleArray(this.blocks.length);
    }

    public BedrockBlockArray(byte[] blocks, NibbleArray data) {
        this.blocks = blocks;
        this.data = data;
    }

    public int index(int x, int y, int z) {
        return (x << 8) + (z << 4) + y;
    }

    public int idAt(int sectionCoordinate) {
        return (this.blocks[sectionCoordinate] & 0xFF) << 4 | this.data.get(sectionCoordinate);
    }

    public void setIdAt(int sectionCoordinate, int id) {
        if (id >> 4 > 255) {
            throw new IllegalArgumentException("Too large block id: " + id);
        }
        this.blocks[sectionCoordinate] = (byte)(id >> 4);
        this.data.set(sectionCoordinate, id & 0xF);
    }

    public int idByIndex(int index) {
        return this.idAt(index);
    }

    public void setIdByIndex(int index, int id) {
        this.setIdAt(index, id);
    }

    public int paletteIndexAt(int packedCoordinate) {
        throw new UnsupportedOperationException();
    }

    public void setPaletteIndexAt(int sectionCoordinate, int index) {
        throw new UnsupportedOperationException();
    }

    public void addId(int id) {
    }

    public void replaceId(int oldId, int newId) {
        for (int i = 0; i < this.size(); ++i) {
            if (this.idAt(i) != oldId) continue;
            this.setIdAt(i, newId);
        }
    }

    public int size() {
        return this.blocks.length;
    }

    public void clear() {
        this.blocks = new byte[this.blocks.length];
        this.data = new NibbleArray(this.blocks.length);
    }

    public BedrockBlockArray clone() {
        return new BedrockBlockArray((byte[])this.blocks.clone(), new NibbleArray((byte[])this.data.getHandle().clone()));
    }

    public byte[] getBlocks() {
        return this.blocks;
    }

    public NibbleArray getData() {
        return this.data;
    }
}

