/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.http;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;

public class BedrockPackDownloader {
    private static final int TIMEOUT = 6000;
    private final URL url;

    public BedrockPackDownloader(URL url) {
        this.url = url;
    }

    public int getContentLength() {
        try {
            HttpURLConnection connection = this.createConnection();
            connection.setRequestMethod("HEAD");
            connection.connect();
            this.checkResponseCode(connection);
            if (connection.getContentLength() < 0) {
                throw new IOException("Content-Length is not set");
            }
            return connection.getContentLength();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public byte[] download() {
        try {
            HttpURLConnection connection = this.createConnection();
            connection.setRequestMethod("GET");
            connection.connect();
            this.checkResponseCode(connection);
            return connection.getInputStream().readAllBytes();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private HttpURLConnection createConnection() throws IOException {
        HttpURLConnection connection = (HttpURLConnection)this.url.openConnection();
        connection.setConnectTimeout(6000);
        connection.setReadTimeout(12000);
        connection.setDoInput(true);
        connection.setDoOutput(false);
        connection.setInstanceFollowRedirects(true);
        connection.setRequestProperty("Accept-Encoding", "gzip, deflate");
        connection.setRequestProperty("Accept", "*/*");
        connection.setRequestProperty("User-Agent", "libhttpclient/1.0.0.0");
        connection.setRequestProperty("Cache-Control", "no-cache");
        return connection;
    }

    private void checkResponseCode(HttpURLConnection connection) throws IOException {
        if (connection.getResponseCode() / 100 != 2) {
            throw new IOException("HTTP response code: " + connection.getResponseCode());
        }
    }
}

