/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;

public class LittleEndianByteBufInputStream
extends ByteBufInputStream {
    private final ByteBuf buffer;

    public LittleEndianByteBufInputStream(ByteBuf buffer) {
        super(buffer);
        this.buffer = buffer;
    }

    public char readChar() {
        return Character.reverseBytes(this.buffer.readChar());
    }

    public double readDouble() {
        return this.buffer.readDoubleLE();
    }

    public float readFloat() {
        return this.buffer.readFloatLE();
    }

    public short readShort() {
        return this.buffer.readShortLE();
    }

    public int readUnsignedShort() {
        return this.buffer.readUnsignedShortLE();
    }

    public long readLong() throws IOException {
        return this.buffer.readLongLE();
    }

    public int readInt() throws IOException {
        return this.buffer.readIntLE();
    }

    public String readUTF() throws IOException {
        return (String)this.buffer.readCharSequence(this.readUnsignedShort(), StandardCharsets.UTF_8);
    }
}

