/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.container.player;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.item.StructuredItem;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPackets1_21_9;
import net.raphimc.viabedrock.api.model.container.Container;
import net.raphimc.viabedrock.api.model.container.player.HudContainer;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.ServerboundBedrockPackets;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ContainerID;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ContainerType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.InteractPacket_Action;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.ItemRewriter;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.InventoryTracker;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class InventoryContainer
extends Container {
    private byte selectedHotbarSlot = 0;

    public InventoryContainer(UserConnection user) {
        super(user, (byte)ContainerID.CONTAINER_ID_INVENTORY.getValue(), ContainerType.INVENTORY, null, null, 36, new String[0]);
    }

    public InventoryContainer(UserConnection user, byte containerId, BlockPosition position, InventoryContainer inventoryContainer) {
        super(user, containerId, inventoryContainer.type, inventoryContainer.title, position, inventoryContainer.items, inventoryContainer.validBlockTags);
        this.selectedHotbarSlot = inventoryContainer.selectedHotbarSlot;
    }

    @Override
    public Item[] getJavaItems() {
        InventoryTracker inventoryTracker = (InventoryTracker)this.user.get(InventoryTracker.class);
        Item[] inventoryItems = super.getJavaItems();
        Item[] armorItems = inventoryTracker.getArmorContainer().getActualJavaItems();
        Item[] offhandItems = inventoryTracker.getOffhandContainer().getActualJavaItems();
        HudContainer hudContainer = inventoryTracker.getHudContainer();
        Item[] combinedItems = StructuredItem.emptyArray((int)46);
        System.arraycopy(armorItems, 0, combinedItems, 5, armorItems.length);
        System.arraycopy(inventoryItems, 9, combinedItems, 9, 27);
        System.arraycopy(inventoryItems, 0, combinedItems, 36, 9);
        System.arraycopy(offhandItems, 0, combinedItems, 45, offhandItems.length);
        for (int i = 0; i < 4; ++i) {
            combinedItems[1 + i] = hudContainer.getJavaItem(28 + i);
        }
        return combinedItems;
    }

    @Override
    public boolean setItems(BedrockItem[] items) {
        if (items.length != this.size()) {
            BedrockItem[] newItems = this.getItems();
            System.arraycopy(items, 0, newItems, 0, Math.min(items.length, newItems.length));
            items = newItems;
        }
        return super.setItems(items);
    }

    @Override
    public int javaSlot(int slot) {
        if (slot < 9) {
            return 36 + slot;
        }
        return super.javaSlot(slot);
    }

    @Override
    public byte javaContainerId() {
        return (byte)ContainerID.CONTAINER_ID_INVENTORY.getValue();
    }

    public byte getSelectedHotbarSlot() {
        return this.selectedHotbarSlot;
    }

    public BedrockItem getSelectedHotbarItem() {
        return this.getItem(this.selectedHotbarSlot);
    }

    public void sendSelectedHotbarSlotToClient() {
        PacketWrapper setHeldSlot = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.SET_HELD_SLOT, (UserConnection)this.user);
        setHeldSlot.write((Type)Types.VAR_INT, (Object)this.selectedHotbarSlot);
        setHeldSlot.send(BedrockProtocol.class);
    }

    public void setSelectedHotbarSlot(byte slot, PacketWrapper mobEquipment) {
        BedrockItem oldItem = this.getItem(this.selectedHotbarSlot);
        BedrockItem newItem = this.getItem(slot);
        this.selectedHotbarSlot = slot;
        this.onSelectedHotbarSlotChanged(oldItem, newItem, mobEquipment);
    }

    @Override
    protected void onSlotChanged(int slot, BedrockItem oldItem, BedrockItem newItem) {
        super.onSlotChanged(slot, oldItem, newItem);
        if (slot == this.selectedHotbarSlot) {
            PacketWrapper mobEquipment = PacketWrapper.create((PacketType)ServerboundBedrockPackets.MOB_EQUIPMENT, (UserConnection)this.user);
            this.onSelectedHotbarSlotChanged(oldItem, newItem, mobEquipment);
            mobEquipment.sendToServer(BedrockProtocol.class);
        }
    }

    private void onSelectedHotbarSlotChanged(BedrockItem oldItem, BedrockItem newItem, PacketWrapper mobEquipment) {
        if (oldItem.isDifferent(newItem)) {
            PacketWrapper interact = PacketWrapper.create((PacketType)ServerboundBedrockPackets.INTERACT, (UserConnection)this.user);
            interact.write((Type)Types.BYTE, (Object)((byte)InteractPacket_Action.InteractUpdate.getValue()));
            interact.write((Type)BedrockTypes.UNSIGNED_VAR_LONG, (Object)0L);
            interact.write(BedrockTypes.POSITION_3F, (Object)Position3f.ZERO);
            interact.sendToServer(BedrockProtocol.class);
        }
        mobEquipment.write((Type)BedrockTypes.UNSIGNED_VAR_LONG, (Object)((EntityTracker)this.user.get(EntityTracker.class)).getClientPlayer().runtimeId());
        mobEquipment.write(((ItemRewriter)this.user.get(ItemRewriter.class)).itemType(), (Object)newItem);
        mobEquipment.write((Type)Types.BYTE, (Object)this.selectedHotbarSlot);
        mobEquipment.write((Type)Types.BYTE, (Object)this.selectedHotbarSlot);
        mobEquipment.write((Type)Types.BYTE, (Object)this.containerId);
    }
}

