/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import com.viaversion.viaversion.util.Key;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import org.cube.converter.data.bedrock.BedrockAttachableData;
import org.cube.converter.parser.bedrock.data.impl.BedrockAttachableParser;

public class AttachableDefinitions {
    private final Map<String, AttachableDefinition> attachables = new HashMap<String, AttachableDefinition>();

    public AttachableDefinitions(ResourcePacksStorage resourcePacksStorage) {
        for (ResourcePack pack : resourcePacksStorage.getPackStackBottomToTop()) {
            for (String attachablePath : pack.content().getFilesDeep("attachables/", ".json")) {
                try {
                    BedrockAttachableData attachableData = BedrockAttachableParser.parse((String)pack.content().getString(attachablePath));
                    String identifier = Key.namespaced((String)attachableData.getIdentifier());
                    this.attachables.put(identifier, new AttachableDefinition(identifier, attachableData));
                }
                catch (Throwable e) {
                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse attachable definition " + attachablePath + " in pack " + String.valueOf(pack.packId()), e);
                }
            }
        }
    }

    public Map<String, AttachableDefinition> attachables() {
        return Collections.unmodifiableMap(this.attachables);
    }

    public record AttachableDefinition(String identifier, BedrockAttachableData attachableData) {
    }
}

