/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.model.resourcepack;

import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class TextureDefinitions {
    private final Map<String, List<ItemTextureDefinition>> itemTextures = new HashMap<String, List<ItemTextureDefinition>>();

    public TextureDefinitions(ResourcePacksStorage resourcePacksStorage) {
        for (ResourcePack pack : resourcePacksStorage.getPackStackBottomToTop()) {
            if (!pack.content().contains("textures/item_texture.json")) continue;
            try {
                JsonObject itemTexture = pack.content().getJson("textures/item_texture.json");
                String textureName = itemTexture.has("texture_name") ? itemTexture.get("texture_name").getAsString() : "atlas.items";
                if (!textureName.equals("atlas.items")) continue;
                JsonObject textureData = itemTexture.getAsJsonObject("texture_data");
                for (Map.Entry entry : textureData.entrySet()) {
                    String name = (String)entry.getKey();
                    JsonElement textures = ((JsonElement)entry.getValue()).getAsJsonObject().get("textures");
                    ArrayList<ItemTextureDefinition> itemTextureDefinitions = new ArrayList<ItemTextureDefinition>();
                    if (textures.isJsonPrimitive() && textures.getAsJsonPrimitive().isString()) {
                        itemTextureDefinitions.add(new ItemTextureDefinition(name, textures.getAsString()));
                    } else if (textures.isJsonArray()) {
                        for (JsonElement texture : textures.getAsJsonArray()) {
                            itemTextureDefinitions.add(new ItemTextureDefinition(name, texture.getAsString()));
                        }
                    }
                    this.itemTextures.put(name, itemTextureDefinitions);
                }
            }
            catch (Throwable e) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Failed to parse item_texture.json in pack " + String.valueOf(pack.packId()), e);
            }
        }
    }

    public Map<String, List<ItemTextureDefinition>> itemTextures() {
        return Collections.unmodifiableMap(this.itemTextures);
    }

    public record ItemTextureDefinition(String name, String texturePath) {
    }
}

