/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.api.util;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class CombinationUtil {
    public static <K, V> List<Map<K, V>> generateCombinations(Map<K, Set<V>> map) {
        ArrayList<Map<K, V>> output = new ArrayList<Map<K, V>>();
        CombinationUtil.generateCombinationsRecursively(map, new LinkedList<K>(map.keySet()).listIterator(), new LinkedHashMap(), output);
        return output;
    }

    private static <K, V> void generateCombinationsRecursively(Map<K, Set<V>> map, ListIterator<K> keys, Map<K, V> cur, List<Map<K, V>> output) {
        if (!keys.hasNext()) {
            LinkedHashMap<K, V> entry = new LinkedHashMap<K, V>();
            for (K key : cur.keySet()) {
                entry.put(key, cur.get(key));
            }
            output.add(entry);
        } else {
            K key = keys.next();
            Set<V> set = map.get(key);
            for (V value : set) {
                cur.put(key, value);
                CombinationUtil.generateCombinationsRecursively(map, keys, cur, output);
                cur.remove(key);
            }
            keys.previous();
        }
    }
}

