/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.experimental.types.inventory;

import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import net.raphimc.viabedrock.experimental.model.inventory.InventorySource;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ContainerID;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.InventorySourceType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.InventorySource_InventorySourceFlags;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class InventorySourcePacketType
extends Type<InventorySource> {
    public InventorySourcePacketType() {
        super(InventorySource.class);
    }

    public InventorySource read(ByteBuf buffer) {
        int rawTypeId = BedrockTypes.UNSIGNED_VAR_INT.read(buffer);
        InventorySourceType type = InventorySourceType.getByValue(rawTypeId);
        if (type == null) {
            throw new IllegalStateException("Invalid inventory source type id: " + rawTypeId);
        }
        switch (type) {
            case ContainerInventory: 
            case NonImplementedFeatureTODO: {
                return new InventorySource(type, BedrockTypes.VAR_INT.read(buffer), InventorySource_InventorySourceFlags.NoFlag);
            }
            case WorldInteraction: {
                int rawSourceFlagId = BedrockTypes.UNSIGNED_VAR_INT.read(buffer);
                InventorySource_InventorySourceFlags flag = InventorySource_InventorySourceFlags.getByValue(rawSourceFlagId);
                if (flag == null) {
                    throw new IllegalStateException("Invalid inventory source flag id: " + rawSourceFlagId);
                }
                return new InventorySource(type, ContainerID.CONTAINER_ID_NONE.getValue(), flag);
            }
        }
        return new InventorySource(type, ContainerID.CONTAINER_ID_NONE.getValue(), InventorySource_InventorySourceFlags.NoFlag);
    }

    public void write(ByteBuf buffer, InventorySource value) {
        BedrockTypes.UNSIGNED_VAR_INT.write(buffer, value.type().getValue());
        switch (value.type()) {
            case ContainerInventory: 
            case NonImplementedFeatureTODO: {
                BedrockTypes.VAR_INT.write(buffer, value.containerId());
                break;
            }
            case WorldInteraction: {
                BedrockTypes.UNSIGNED_VAR_INT.write(buffer, value.flags().getValue());
            }
        }
    }
}

