/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.experimental.types.inventory;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.BlockPosition;
import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.raphimc.viabedrock.experimental.model.inventory.BedrockInventoryTransaction;
import net.raphimc.viabedrock.experimental.model.inventory.InventoryActionData;
import net.raphimc.viabedrock.experimental.model.inventory.InventoryTransactionData;
import net.raphimc.viabedrock.experimental.model.inventory.LegacySetItemSlotData;
import net.raphimc.viabedrock.experimental.types.ExperimentalBedrockTypes;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.ItemUseInventoryTransaction_TriggerType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ComplexInventoryTransaction_Type;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ItemReleaseInventoryTransaction_ActionType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ItemUseInventoryTransaction_ActionType;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ItemUseInventoryTransaction_PredictedResult;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.ItemUseOnActorInventoryTransaction_ActionType;
import net.raphimc.viabedrock.protocol.model.BedrockItem;
import net.raphimc.viabedrock.protocol.model.Position3f;
import net.raphimc.viabedrock.protocol.rewriter.ItemRewriter;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class InventoryTransactionPacketType
extends Type<BedrockInventoryTransaction> {
    private final UserConnection user;
    private final Type<InventoryActionData[]> inventoryActionDataType;

    public InventoryTransactionPacketType(UserConnection user, Type<InventoryActionData[]> inventoryActionDataType) {
        super(BedrockInventoryTransaction.class);
        this.user = user;
        this.inventoryActionDataType = inventoryActionDataType;
    }

    public BedrockInventoryTransaction read(ByteBuf buffer) {
        ItemRewriter itemRewriter = (ItemRewriter)this.user.get(ItemRewriter.class);
        if (itemRewriter == null) {
            throw new IllegalStateException("ItemRewriter not found for user " + String.valueOf(this.user));
        }
        int legacyRequestId = BedrockTypes.VAR_INT.read(buffer);
        LegacySetItemSlotData[] legacySlots = new LegacySetItemSlotData[]{};
        if (legacyRequestId != 0) {
            legacySlots = (LegacySetItemSlotData[])ExperimentalBedrockTypes.LEGACY_SET_ITEM_SLOT_DATA.read(buffer);
        }
        ComplexInventoryTransaction_Type type = ComplexInventoryTransaction_Type.getByValue(BedrockTypes.UNSIGNED_VAR_INT.read(buffer));
        InventoryActionData[] actions = (InventoryActionData[])this.inventoryActionDataType.read(buffer);
        Record transactionData = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ComplexInventoryTransaction_Type.NormalTransaction -> new InventoryTransactionData.NormalTransactionData();
            case ComplexInventoryTransaction_Type.InventoryMismatch -> new InventoryTransactionData.MismatchTransactionData();
            case ComplexInventoryTransaction_Type.ItemUseTransaction -> new InventoryTransactionData.UseItemTransactionData(ItemUseInventoryTransaction_ActionType.getByValue(BedrockTypes.UNSIGNED_VAR_INT.read(buffer)), ItemUseInventoryTransaction_TriggerType.getByValue(BedrockTypes.UNSIGNED_VAR_INT.read(buffer)), (BlockPosition)BedrockTypes.BLOCK_POSITION.read(buffer), BedrockTypes.VAR_INT.read(buffer), BedrockTypes.VAR_INT.read(buffer), (BedrockItem)itemRewriter.itemType().read(buffer), (Position3f)BedrockTypes.POSITION_3F.read(buffer), (Position3f)BedrockTypes.POSITION_3F.read(buffer), BedrockTypes.UNSIGNED_VAR_INT.read(buffer), ItemUseInventoryTransaction_PredictedResult.getByValue(BedrockTypes.UNSIGNED_VAR_INT.read(buffer)));
            case ComplexInventoryTransaction_Type.ItemUseOnEntityTransaction -> new InventoryTransactionData.UseItemOnEntityTransactionData(BedrockTypes.VAR_LONG.read(buffer), ItemUseOnActorInventoryTransaction_ActionType.getByValue(BedrockTypes.UNSIGNED_VAR_INT.read(buffer)), BedrockTypes.VAR_INT.read(buffer), (BedrockItem)itemRewriter.itemType().read(buffer), (Position3f)BedrockTypes.POSITION_3F.read(buffer), (Position3f)BedrockTypes.POSITION_3F.read(buffer));
            case ComplexInventoryTransaction_Type.ItemReleaseTransaction -> new InventoryTransactionData.ReleaseItemTransactionData(ItemReleaseInventoryTransaction_ActionType.getByValue(BedrockTypes.UNSIGNED_VAR_INT.read(buffer)), BedrockTypes.VAR_INT.read(buffer), (BedrockItem)itemRewriter.itemType().read(buffer), (Position3f)BedrockTypes.POSITION_3F.read(buffer));
        };
        return new BedrockInventoryTransaction(legacyRequestId, List.of(legacySlots), List.of(actions), type, (InventoryTransactionData)((Object)transactionData));
    }

    public void write(ByteBuf buffer, BedrockInventoryTransaction bedrockInventoryTransaction) {
        ItemRewriter itemRewriter = (ItemRewriter)this.user.get(ItemRewriter.class);
        if (itemRewriter == null) {
            throw new IllegalStateException("ItemRewriter not found for user " + String.valueOf(this.user));
        }
        BedrockTypes.VAR_INT.write(buffer, bedrockInventoryTransaction.legacyRequestId());
        if (bedrockInventoryTransaction.legacyRequestId() != 0) {
            ExperimentalBedrockTypes.LEGACY_SET_ITEM_SLOT_DATA.write(buffer, (Object)bedrockInventoryTransaction.legacySlots().toArray(new LegacySetItemSlotData[0]));
        }
        BedrockTypes.UNSIGNED_VAR_INT.write(buffer, bedrockInventoryTransaction.transactionType().getValue());
        if (bedrockInventoryTransaction.actions() != null) {
            this.inventoryActionDataType.write(buffer, (Object)bedrockInventoryTransaction.actions().toArray(new InventoryActionData[0]));
        } else {
            this.inventoryActionDataType.write(buffer, (Object)new InventoryActionData[0]);
        }
        switch (bedrockInventoryTransaction.transactionType()) {
            case NormalTransaction: 
            case InventoryMismatch: {
                break;
            }
            case ItemUseTransaction: {
                InventoryTransactionData.UseItemTransactionData data = (InventoryTransactionData.UseItemTransactionData)bedrockInventoryTransaction.transactionData();
                BedrockTypes.UNSIGNED_VAR_INT.write(buffer, data.actionType().getValue());
                BedrockTypes.UNSIGNED_VAR_INT.write(buffer, data.triggerType().getValue());
                BedrockTypes.BLOCK_POSITION.write(buffer, (Object)data.blockPosition());
                BedrockTypes.VAR_INT.write(buffer, data.face());
                BedrockTypes.VAR_INT.write(buffer, data.hotbarSlot());
                itemRewriter.itemType().write(buffer, (Object)data.itemInHand());
                BedrockTypes.POSITION_3F.write(buffer, (Object)data.playerPosition());
                BedrockTypes.POSITION_3F.write(buffer, (Object)data.clickPosition());
                BedrockTypes.UNSIGNED_VAR_INT.write(buffer, data.blockRuntimeId());
                BedrockTypes.UNSIGNED_VAR_INT.write(buffer, data.predictedResult().getValue());
                break;
            }
            case ItemUseOnEntityTransaction: {
                InventoryTransactionData.UseItemOnEntityTransactionData data = (InventoryTransactionData.UseItemOnEntityTransactionData)bedrockInventoryTransaction.transactionData();
                BedrockTypes.VAR_LONG.write(buffer, data.entityRuntimeId());
                BedrockTypes.UNSIGNED_VAR_INT.write(buffer, data.actionType().getValue());
                BedrockTypes.VAR_INT.write(buffer, data.hotbarSlot());
                itemRewriter.itemType().write(buffer, (Object)data.itemInHand());
                BedrockTypes.POSITION_3F.write(buffer, (Object)data.playerPosition());
                BedrockTypes.POSITION_3F.write(buffer, (Object)data.clickPosition());
                break;
            }
            case ItemReleaseTransaction: {
                InventoryTransactionData.ReleaseItemTransactionData data = (InventoryTransactionData.ReleaseItemTransactionData)bedrockInventoryTransaction.transactionData();
                BedrockTypes.UNSIGNED_VAR_INT.write(buffer, data.actionType().getValue());
                BedrockTypes.VAR_INT.write(buffer, data.hotbarSlot());
                itemRewriter.itemType().write(buffer, (Object)data.itemInHand());
                BedrockTypes.POSITION_3F.write(buffer, (Object)data.headPosition());
            }
        }
    }
}

