/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.netty.util;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageCodec;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;

public class DatagramCodec
extends MessageToMessageCodec<DatagramPacket, ByteBuf> {
    private final InetSocketAddress remoteAddress;

    public DatagramCodec() {
        this(null);
    }

    public DatagramCodec(InetSocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.remoteAddress != null) {
            out.add(new DatagramPacket(in.retain(), this.remoteAddress));
        } else {
            SocketAddress socketAddress = ctx.channel().remoteAddress();
            if (socketAddress instanceof InetSocketAddress) {
                InetSocketAddress remoteAddress = (InetSocketAddress)socketAddress;
                out.add(new DatagramPacket(in.retain(), remoteAddress));
            } else {
                throw new IllegalStateException("Channel remote address is not an InetSocketAddress and no remote address was specified");
            }
        }
    }

    protected void decode(ChannelHandlerContext ctx, DatagramPacket in, List<Object> out) {
        if (in.sender() == null || ((InetSocketAddress)in.sender()).equals(this.remoteAddress) || ((InetSocketAddress)in.sender()).equals(ctx.channel().remoteAddress())) {
            out.add(((ByteBuf)in.content()).retain());
        }
    }
}

