/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.AbstractSimpleProtocol;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.FixedByteArrayType;
import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.protocols.base.ClientboundStatusPackets;
import com.viaversion.viaversion.protocols.base.ServerboundStatusPackets;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import java.security.NoSuchAlgorithmException;
import java.util.HexFormat;
import java.util.concurrent.ThreadLocalRandom;
import net.raphimc.viabedrock.netty.nethernet.DiscoveryEncryptionCodec;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.GameType;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class NetherNetStatusProtocol
extends AbstractSimpleProtocol {
    public static final NetherNetStatusProtocol INSTANCE = new NetherNetStatusProtocol();
    private static final long APPLICATION_ID = 3735928559L;
    private static final short ID_DISCOVERY_REQUEST = 0;
    private static final short ID_DISCOVERY_RESPONSE = 1;
    private static final short ID_DISCOVERY_MESSAGE = 2;
    private static final byte[] PADDING_BYTES = new byte[8];
    private static final Type<byte[]> PADDING_TYPE = new FixedByteArrayType(PADDING_BYTES.length);

    private NetherNetStatusProtocol() {
        this.initialize();
    }

    protected void registerPackets() {
        this.registerClientbound(State.STATUS, 1, ClientboundStatusPackets.STATUS_RESPONSE.getId(), wrapper -> {
            wrapper.read((Type)Types.BYTE);
            ((PingInfoStorage)wrapper.user().get(PingInfoStorage.class)).serverNetworkId = (Long)wrapper.read((Type)BedrockTypes.LONG_LE);
            wrapper.read(PADDING_TYPE);
            String rawData = (String)wrapper.read(BedrockTypes.ASCII_STRING);
            JsonObject statusResponse = new JsonObject();
            JsonObject version = new JsonObject();
            version.addProperty("name", "");
            version.addProperty("protocol", (Number)wrapper.user().getProtocolInfo().protocolVersion().getVersion());
            statusResponse.add("version", (JsonElement)version);
            ByteBuf data = Unpooled.wrappedBuffer((byte[])HexFormat.of().parseHex(rawData));
            short dataVersion = data.readUnsignedByte();
            if (dataVersion != 4) {
                throw new IllegalStateException("Unsupported NetherNet discovery response version: " + dataVersion);
            }
            String serverName = (String)BedrockTypes.STRING.read(data);
            String levelName = (String)BedrockTypes.STRING.read(data);
            statusResponse.addProperty("description", "Server: " + serverName + "\n\u00a7rLevel: " + levelName);
            JsonArray samples = new JsonArray();
            samples.add((JsonElement)this.createPlayerSample("GameType: " + GameType.getByValue(data.readUnsignedByte() >> 1, GameType.Undefined).name()));
            JsonObject players = new JsonObject();
            players.addProperty("online", (Number)data.readIntLE());
            players.addProperty("max", (Number)data.readIntLE());
            players.add("sample", (JsonElement)samples);
            statusResponse.add("players", (JsonElement)players);
            samples.add((JsonElement)this.createPlayerSample("Editor World: " + data.readBoolean()));
            samples.add((JsonElement)this.createPlayerSample("Hardcore: " + data.readBoolean()));
            data.skipBytes(2);
            data.release();
            wrapper.write(Types.STRING, (Object)statusResponse.toString());
        });
        this.registerClientbound(State.STATUS, 2, ClientboundStatusPackets.PONG_RESPONSE.getId(), wrapper -> {
            wrapper.read((Type)Types.BYTE);
            wrapper.read((Type)BedrockTypes.LONG_LE);
            wrapper.read(PADDING_TYPE);
            wrapper.read((Type)BedrockTypes.LONG_LE);
            String message = (String)wrapper.read(BedrockTypes.ASCII_STRING);
            if (!message.equals("Ping")) {
                throw new IllegalStateException("Unsupported NetherNet discovery message: " + message);
            }
            wrapper.write((Type)Types.LONG, (Object)((PingInfoStorage)wrapper.user().get(PingInfoStorage.class)).pingTime);
        });
        this.registerServerbound(State.STATUS, ServerboundStatusPackets.STATUS_REQUEST.getId(), 0, wrapper -> {
            wrapper.write((Type)Types.BYTE, (Object)0);
            wrapper.write((Type)BedrockTypes.LONG_LE, (Object)((PingInfoStorage)wrapper.user().get(PingInfoStorage.class)).clientNetworkId);
            wrapper.write(PADDING_TYPE, (Object)PADDING_BYTES);
        });
        this.registerServerbound(State.STATUS, ServerboundStatusPackets.PING_REQUEST.getId(), 2, wrapper -> {
            PingInfoStorage pingInfoStorage = (PingInfoStorage)wrapper.user().get(PingInfoStorage.class);
            pingInfoStorage.pingTime = (Long)wrapper.read((Type)Types.LONG);
            wrapper.write((Type)Types.BYTE, (Object)0);
            wrapper.write((Type)BedrockTypes.LONG_LE, (Object)pingInfoStorage.clientNetworkId);
            wrapper.write(PADDING_TYPE, (Object)PADDING_BYTES);
            wrapper.write((Type)BedrockTypes.LONG_LE, (Object)pingInfoStorage.serverNetworkId);
            wrapper.write(BedrockTypes.ASCII_STRING, (Object)"Ping");
        });
    }

    public void init(UserConnection connection) {
        connection.put((StorableObject)new PingInfoStorage(ThreadLocalRandom.current().nextLong()));
        if (connection.getChannel() != null) {
            try {
                connection.getChannel().pipeline().addBefore(Via.getManager().getInjector().getEncoderName(), "viabedrock-nethernet-discovery-encryption", (ChannelHandler)new DiscoveryEncryptionCodec(3735928559L));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Failed to initialize NetherNet encryption codec", e);
            }
        }
    }

    public boolean isBaseProtocol() {
        return true;
    }

    private JsonObject createPlayerSample(String text) {
        JsonObject sample = new JsonObject();
        sample.addProperty("name", text);
        sample.addProperty("id", "00000000-0000-0000-0000-000000000000");
        return sample;
    }

    private static class PingInfoStorage
    implements StorableObject {
        private final long clientNetworkId;
        private long serverNetworkId;
        private long pingTime;

        private PingInfoStorage(long clientNetworkId) {
            this.clientNetworkId = clientNetworkId;
        }
    }
}

