/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol;

import com.viaversion.viaversion.api.connection.StorableObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.AbstractSimpleProtocol;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.protocol.packet.State;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.FixedByteArrayType;
import com.viaversion.viaversion.libs.gson.JsonArray;
import com.viaversion.viaversion.libs.gson.JsonElement;
import com.viaversion.viaversion.libs.gson.JsonObject;
import com.viaversion.viaversion.protocols.base.ClientboundStatusPackets;
import com.viaversion.viaversion.protocols.base.ServerboundStatusPackets;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;

public class RakNetStatusProtocol
extends AbstractSimpleProtocol {
    public static final RakNetStatusProtocol INSTANCE = new RakNetStatusProtocol();
    private static final byte[] OFFLINE_MESSAGE_DATA_ID = new byte[]{0, -1, -1, 0, -2, -2, -2, -2, -3, -3, -3, -3, 18, 52, 86, 120};
    private static final byte ID_UNCONNECTED_PING = 1;
    private static final byte ID_UNCONNECTED_PONG = 28;
    private static final Type<byte[]> OFFLINE_MESSAGE_DATA_ID_TYPE = new FixedByteArrayType(OFFLINE_MESSAGE_DATA_ID.length);

    private RakNetStatusProtocol() {
        this.initialize();
    }

    protected void registerPackets() {
        this.registerClientbound(State.STATUS, 28, ClientboundStatusPackets.STATUS_RESPONSE.getId(), wrapper -> {
            long ping = (System.nanoTime() - ((PingInfoStorage)wrapper.user().get(PingInfoStorage.class)).pingStartTime) / 1000000L;
            wrapper.read((Type)Types.LONG);
            wrapper.read((Type)Types.LONG);
            byte[] offlineMessageDataId = (byte[])wrapper.read(OFFLINE_MESSAGE_DATA_ID_TYPE);
            if (!Arrays.equals(offlineMessageDataId, OFFLINE_MESSAGE_DATA_ID)) {
                throw new IllegalStateException("Invalid offline message data id");
            }
            byte[] data = (byte[])wrapper.read(Types.SHORT_BYTE_ARRAY);
            JsonObject statusResponse = new JsonObject();
            statusResponse.addProperty("description", "");
            JsonObject version = new JsonObject();
            version.addProperty("name", "");
            version.addProperty("protocol", (Number)wrapper.user().getProtocolInfo().protocolVersion().getVersion());
            statusResponse.add("version", (JsonElement)version);
            JsonArray samples = new JsonArray();
            samples.add((JsonElement)this.createPlayerSample("Ping: " + ping + "ms"));
            JsonObject players = new JsonObject();
            players.addProperty("online", (Number)-1);
            players.addProperty("max", (Number)-1);
            players.add("sample", (JsonElement)samples);
            statusResponse.add("players", (JsonElement)players);
            String[] splitData = new String(data, StandardCharsets.UTF_8).split(";");
            switch (splitData.length) {
                default: {
                    samples.add((JsonElement)this.createPlayerSample("IPv6 Port: " + splitData[11]));
                }
                case 11: {
                    samples.add((JsonElement)this.createPlayerSample("IPv4 Port: " + splitData[10]));
                }
                case 10: {
                    samples.add((JsonElement)this.createPlayerSample("Nintendo limited: " + !"1".equalsIgnoreCase(splitData[9])));
                }
                case 9: {
                    samples.add((JsonElement)this.createPlayerSample("GameType: " + splitData[8]));
                }
                case 6: 
                case 7: 
                case 8: {
                    try {
                        players.addProperty("max", (Number)Integer.parseInt(splitData[5]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                case 5: {
                    try {
                        players.addProperty("online", (Number)Integer.parseInt(splitData[4]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                case 3: 
                case 4: {
                    samples.add((JsonElement)this.createPlayerSample("Protocol: " + splitData[2]));
                }
                case 2: {
                    statusResponse.addProperty("description", splitData[1] + (String)(splitData.length >= 8 ? "\n\u00a7r" + splitData[7] : ""));
                }
                case 1: {
                    String versionName = splitData[0] + (String)(splitData.length >= 4 ? " " + splitData[3] : "");
                    version.addProperty("name", versionName);
                    samples.add((JsonElement)this.createPlayerSample("Version: " + versionName));
                }
                case 0: 
            }
            wrapper.write(Types.STRING, (Object)statusResponse.toString());
        });
        this.registerServerbound(State.STATUS, ServerboundStatusPackets.STATUS_REQUEST.getId(), 1, wrapper -> {
            wrapper.write((Type)Types.LONG, (Object)(System.nanoTime() / 1000000L));
            wrapper.write(OFFLINE_MESSAGE_DATA_ID_TYPE, (Object)OFFLINE_MESSAGE_DATA_ID);
            wrapper.write((Type)Types.LONG, (Object)ThreadLocalRandom.current().nextLong());
            wrapper.user().put((StorableObject)new PingInfoStorage(System.nanoTime()));
        });
        this.registerServerbound(State.STATUS, ServerboundStatusPackets.PING_REQUEST.getId(), -1, wrapper -> {
            wrapper.cancel();
            PacketWrapper pongResponse = PacketWrapper.create((PacketType)ClientboundStatusPackets.PONG_RESPONSE, (UserConnection)wrapper.user());
            pongResponse.write((Type)Types.LONG, (Object)((Long)wrapper.read((Type)Types.LONG)));
            pongResponse.send(RakNetStatusProtocol.class);
        });
    }

    public boolean isBaseProtocol() {
        return true;
    }

    private JsonObject createPlayerSample(String text) {
        JsonObject sample = new JsonObject();
        sample.addProperty("name", text);
        sample.addProperty("id", "00000000-0000-0000-0000-000000000000");
        return sample;
    }

    private record PingInfoStorage(long pingStartTime) implements StorableObject
    {
    }
}

