/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.data.enums.java;

import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2ObjectOpenHashMap;

public enum EntityEvent {
    JUMP(1),
    DEATH(3),
    START_ATTACKING(4),
    STOP_ATTACKING(5),
    TAMING_FAILED(6),
    TAMING_SUCCEEDED(7),
    SHAKE_WETNESS(8),
    USE_ITEM_COMPLETE(9),
    EAT_GRASS(10),
    OFFER_FLOWER(11),
    LOVE_HEARTS(12),
    VILLAGER_ANGRY(13),
    VILLAGER_HAPPY(14),
    WITCH_HAT_MAGIC(15),
    ZOMBIE_CONVERTING(16),
    FIREWORKS_EXPLODE(17),
    IN_LOVE_HEARTS(18),
    SQUID_ANIM_SYNCH(19),
    SILVERFISH_MERGE_ANIM(20),
    GUARDIAN_ATTACK_SOUND(21),
    REDUCED_DEBUG_INFO(22),
    FULL_DEBUG_INFO(23),
    PERMISSION_LEVEL_ALL(24),
    PERMISSION_LEVEL_MODERATORS(25),
    PERMISSION_LEVEL_GAMEMASTERS(26),
    PERMISSION_LEVEL_ADMINS(27),
    PERMISSION_LEVEL_OWNERS(28),
    FISHING_ROD_REEL_IN(31),
    ARMORSTAND_WOBBLE(32),
    STOP_OFFER_FLOWER(34),
    PROTECTED_FROM_DEATH(35),
    DOLPHIN_LOOKING_FOR_TREASURE(38),
    RAVAGER_STUNNED(39),
    TRUSTING_FAILED(40),
    TRUSTING_SUCCEEDED(41),
    VILLAGER_SWEAT(42),
    FOX_EAT(45),
    TELEPORT(46),
    MAINHAND_BREAK(47),
    OFFHAND_BREAK(48),
    HEAD_BREAK(49),
    CHEST_BREAK(50),
    LEGS_BREAK(51),
    FEET_BREAK(52),
    HONEY_SLIDE(53),
    HONEY_JUMP(54),
    SWAP_HANDS(55),
    CANCEL_SHAKE_WETNESS(56),
    START_RAM(58),
    END_RAM(59),
    POOF(60),
    TENDRILS_SHIVER(61),
    SONIC_CHARGE(62),
    SNIFFER_DIGGING_SOUND(63),
    ARMADILLO_PEEK(64),
    BODY_BREAK(65),
    SHAKE(66),
    DROWN_PARTICLES(67),
    SADDLE_BREAK(68),
    RAVAGER_ROARED(69);

    private static final Int2ObjectMap<EntityEvent> BY_VALUE;
    private final byte value;

    public static EntityEvent getByValue(byte value) {
        return (EntityEvent)((Object)BY_VALUE.get((int)value));
    }

    public static EntityEvent getByValue(byte value, EntityEvent fallback) {
        return (EntityEvent)((Object)BY_VALUE.getOrDefault((int)value, (Object)fallback));
    }

    private EntityEvent(int value) {
        this.value = (byte)value;
    }

    public byte getValue() {
        return this.value;
    }

    static {
        BY_VALUE = new Int2ObjectOpenHashMap();
        for (EntityEvent value : EntityEvent.values()) {
            BY_VALUE.put((int)value.value, (Object)value);
        }
    }
}

