/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.blockentity;

import com.viaversion.nbt.tag.ByteTag;
import com.viaversion.nbt.tag.CompoundTag;
import com.viaversion.nbt.tag.IntTag;
import com.viaversion.nbt.tag.ListTag;
import com.viaversion.nbt.tag.LongTag;
import com.viaversion.nbt.tag.StringTag;
import com.viaversion.nbt.tag.Tag;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntity;
import com.viaversion.viaversion.api.minecraft.blockentity.BlockEntityImpl;
import com.viaversion.viaversion.libs.mcstructs.text.TextComponent;
import java.util.ArrayList;
import net.lenni0451.mcstructs_bedrock.text.utils.BedrockTextUtils;
import net.raphimc.viabedrock.api.chunk.BedrockBlockEntity;
import net.raphimc.viabedrock.api.util.TextUtil;
import net.raphimc.viabedrock.protocol.data.enums.DyeColor;
import net.raphimc.viabedrock.protocol.rewriter.BlockEntityRewriter;

public class SignBlockEntityRewriter
implements BlockEntityRewriter.Rewriter {
    private static final String[] TEXT_CONTAINER_KEYS = new String[]{"FrontText", "BackText"};

    public static void upgradeData(CompoundTag data) {
        if (data.get("Text1") instanceof StringTag) {
            StringBuilder textBuilder = new StringBuilder();
            for (int i = 1; i <= 4; ++i) {
                if (!textBuilder.isEmpty()) {
                    textBuilder.append("\n\u00a7r");
                }
                textBuilder.append(data.getString("Text" + i, ""));
            }
            CompoundTag frontText = new CompoundTag();
            frontText.putString("Text", textBuilder.toString());
            frontText.putByte("IgnoreLighting", (byte)0);
            frontText.putByte("PersistFormatting", (byte)1);
            data.clear();
            data.put("FrontText", (Tag)frontText);
        } else if (data.get("Text") instanceof StringTag) {
            ByteTag textIgnoreLegacyBugResolvedTag;
            Tag tag = data.get("TextIgnoreLegacyBugResolved");
            if (!(tag instanceof ByteTag) || (textIgnoreLegacyBugResolvedTag = (ByteTag)tag).asByte() == 0) {
                data.putByte("HideGlowOutline", (byte)1);
            }
            CompoundTag frontText = data.copy();
            data.keySet().removeIf(key -> !key.equals("IsWaxed") && !key.equals("LockedForEditingBy"));
            data.put("FrontText", (Tag)frontText);
        }
    }

    public static void sanitizeData(CompoundTag data) {
        for (String textContainerKey : TEXT_CONTAINER_KEYS) {
            CompoundTag textContainer;
            if (!(data.get(textContainerKey) instanceof CompoundTag)) {
                textContainer = new CompoundTag();
                textContainer.putByte("IgnoreLighting", (byte)0);
                textContainer.putByte("PersistFormatting", (byte)1);
                data.put(textContainerKey, (Tag)textContainer);
            }
            textContainer = data.getCompoundTag(textContainerKey);
            CompoundTag sanitizedTextContainer = new CompoundTag();
            Tag tag = textContainer.get("FilteredText");
            if (tag instanceof StringTag) {
                StringTag filteredText = (StringTag)tag;
                sanitizedTextContainer.put("FilteredText", (Tag)filteredText);
            } else {
                sanitizedTextContainer.putString("FilteredText", "");
            }
            tag = textContainer.get("HideGlowOutline");
            if (tag instanceof ByteTag) {
                ByteTag hideGlowOutline = (ByteTag)tag;
                sanitizedTextContainer.put("HideGlowOutline", (Tag)hideGlowOutline);
            } else {
                sanitizedTextContainer.putByte("HideGlowOutline", (byte)0);
            }
            tag = textContainer.get("IgnoreLighting");
            if (tag instanceof ByteTag) {
                ByteTag ignoreLighting = (ByteTag)tag;
                sanitizedTextContainer.put("IgnoreLighting", (Tag)ignoreLighting);
            } else {
                sanitizedTextContainer.putByte("IgnoreLighting", (byte)1);
            }
            tag = textContainer.get("PersistFormatting");
            if (tag instanceof ByteTag) {
                ByteTag persistFormatting = (ByteTag)tag;
                sanitizedTextContainer.put("PersistFormatting", (Tag)persistFormatting);
            } else {
                sanitizedTextContainer.putByte("PersistFormatting", (byte)0);
            }
            tag = textContainer.get("SignTextColor");
            if (tag instanceof IntTag) {
                IntTag signTextColor = (IntTag)tag;
                sanitizedTextContainer.put("SignTextColor", (Tag)signTextColor);
            } else {
                sanitizedTextContainer.putInt("SignTextColor", DyeColor.BLACK.signColor());
            }
            tag = textContainer.get("Text");
            if (tag instanceof StringTag) {
                StringTag text = (StringTag)tag;
                sanitizedTextContainer.put("Text", (Tag)text);
            } else {
                sanitizedTextContainer.putString("Text", "");
            }
            tag = textContainer.get("TextOwner");
            if (tag instanceof StringTag) {
                StringTag textOwner = (StringTag)tag;
                sanitizedTextContainer.put("TextOwner", (Tag)textOwner);
            } else {
                sanitizedTextContainer.putString("TextOwner", "");
            }
            data.put(textContainerKey, (Tag)sanitizedTextContainer);
        }
        if (!(data.get("IsWaxed") instanceof ByteTag)) {
            data.putByte("IsWaxed", (byte)0);
        }
        if (!(data.get("LockedForEditingBy") instanceof LongTag)) {
            data.putLong("LockedForEditingBy", -1L);
        }
    }

    @Override
    public BlockEntity toJava(UserConnection user, BedrockBlockEntity bedrockBlockEntity) {
        CompoundTag bedrockTag = bedrockBlockEntity.tag().copy();
        SignBlockEntityRewriter.upgradeData(bedrockTag);
        CompoundTag javaTag = new CompoundTag();
        Tag tag = bedrockTag.get("FrontText");
        if (tag instanceof CompoundTag) {
            CompoundTag frontText = (CompoundTag)tag;
            javaTag.put("front_text", (Tag)this.translateText(frontText));
        }
        if ((tag = bedrockTag.get("BackText")) instanceof CompoundTag) {
            CompoundTag backText = (CompoundTag)tag;
            javaTag.put("back_text", (Tag)this.translateText(backText));
        }
        this.copy(bedrockTag, javaTag, "IsWaxed", "is_waxed", ByteTag.class);
        return new BlockEntityImpl(bedrockBlockEntity.packedXZ(), bedrockBlockEntity.y(), -1, javaTag);
    }

    private CompoundTag translateText(CompoundTag bedrockText) {
        ByteTag hideGlowOutlineTag;
        boolean hideGlowOutline;
        ByteTag ignoreLightingTag;
        Tag tag;
        ByteTag persistFormatting;
        CompoundTag javaText = new CompoundTag();
        String text = bedrockText.getString("Text", "");
        ArrayList<TextComponent> components = new ArrayList<TextComponent>();
        String[] stringArray = bedrockText.get("PersistFormatting");
        if (stringArray instanceof ByteTag && (persistFormatting = (ByteTag)stringArray).asByte() != 0) {
            for (String line : BedrockTextUtils.split((String)text, (String)"\n")) {
                components.add(TextUtil.stringToTextComponent(line));
            }
        } else {
            for (String line : text.split("\n")) {
                components.add(TextUtil.stringToTextComponent(line));
            }
        }
        boolean ignoreLighting = !((tag = bedrockText.get("IgnoreLighting")) instanceof ByteTag) || (ignoreLightingTag = (ByteTag)tag).asByte() != 0;
        Tag tag2 = bedrockText.get("HideGlowOutline");
        boolean bl = hideGlowOutline = tag2 instanceof ByteTag && (hideGlowOutlineTag = (ByteTag)tag2).asByte() != 0;
        if (!hideGlowOutline && ignoreLighting) {
            javaText.putByte("has_glowing_text", (byte)1);
        }
        if ((tag2 = bedrockText.get("SignTextColor")) instanceof IntTag) {
            IntTag signTextColorTag = (IntTag)tag2;
            int signTextColor = signTextColorTag.asInt();
            if ((signTextColor >> 24 & 0xFF) < 100) {
                components.clear();
            }
            javaText.putString("color", DyeColor.getClosestDyeColor(signTextColor).name().toLowerCase());
            for (TextComponent component : components) {
                component.forEach(c -> c.getStyle().setColor(signTextColor));
            }
        }
        ListTag messages = new ListTag(CompoundTag.class);
        for (int i = 0; i < 4; ++i) {
            messages.add((Tag)TextUtil.ensureCompoundTag(components.size() > i ? TextUtil.textComponentToNbt((TextComponent)components.get(i)) : TextUtil.stringToNbt("")));
        }
        javaText.put("messages", (Tag)messages);
        return javaText;
    }
}

