/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.rewriter.resourcepack;

import java.util.Map;
import java.util.Set;
import net.raphimc.viabedrock.api.model.resourcepack.EntityDefinitions;
import net.raphimc.viabedrock.api.model.resourcepack.ResourcePack;
import net.raphimc.viabedrock.protocol.rewriter.resourcepack.ItemModelResourceRewriter;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;
import org.cube.converter.converter.enums.RotationType;
import org.cube.converter.model.impl.bedrock.BedrockGeometryModel;
import org.cube.converter.model.impl.java.JavaItemModel;

public class CustomEntityResourceRewriter
extends ItemModelResourceRewriter {
    public CustomEntityResourceRewriter() {
        super("entity", "entity");
    }

    @Override
    protected void apply(ResourcePacksStorage resourcePacksStorage, ResourcePack.Content javaContent, Set<String> modelsList) {
        for (Map.Entry<String, EntityDefinitions.EntityDefinition> entityEntry : resourcePacksStorage.getEntities().entities().entrySet()) {
            block1: for (String bedrockPath : entityEntry.getValue().entityData().getTextures().values()) {
                for (ResourcePack pack : resourcePacksStorage.getPackStackTopToBottom()) {
                    ResourcePack.Content bedrockContent = pack.content();
                    ResourcePack.Content.LazyImage texture = bedrockContent.getShortnameImage(bedrockPath);
                    if (texture == null) continue;
                    javaContent.putPngImage("assets/viabedrock/textures/" + this.getJavaTexturePath(bedrockPath) + ".png", texture);
                    continue block1;
                }
            }
            EntityDefinitions.EntityDefinition entityDefinition = entityEntry.getValue();
            for (Map.Entry modelEntry : entityDefinition.entityData().getGeometries().entrySet()) {
                BedrockGeometryModel bedrockGeometry = resourcePacksStorage.getModels().entityModels().get(modelEntry.getValue());
                if (bedrockGeometry == null) continue;
                for (Map.Entry textureEntry : entityDefinition.entityData().getTextures().entrySet()) {
                    String javaTexturePath = this.getJavaTexturePath((String)textureEntry.getValue());
                    String key = entityEntry.getKey() + "_" + (String)modelEntry.getKey() + "_" + (String)textureEntry.getKey();
                    JavaItemModel itemModelData = bedrockGeometry.toJavaItemModel("viabedrock:" + javaTexturePath, RotationType.HACKY_POST_1_21_6);
                    resourcePacksStorage.getConverterData().put("ce_" + key + "_scale", Float.valueOf(itemModelData.getScale()));
                    javaContent.putString("assets/viabedrock/models/" + this.getJavaModelName(key) + ".json", itemModelData.compile().toString());
                    modelsList.add(key);
                }
            }
        }
    }
}

