/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.connection.StorableObject;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class AuthData
implements StorableObject {
    private final String mojangJwt;
    private final String identityJwt;
    private final String multiplayerToken;
    private final KeyPair sessionKeyPair;
    private final UUID deviceId;
    private String selfSignedJwt;
    private String skinJwt;
    private String displayName;
    private String xuid;

    public AuthData(String mojangJwt, String identityJwt, String multiplayerToken, KeyPair sessionKeyPair, UUID deviceId) {
        this.mojangJwt = mojangJwt;
        this.identityJwt = identityJwt;
        this.multiplayerToken = multiplayerToken;
        this.sessionKeyPair = sessionKeyPair;
        this.deviceId = deviceId;
    }

    public String getMojangJwt() {
        return this.mojangJwt;
    }

    public String getIdentityJwt() {
        return this.identityJwt;
    }

    public String getMultiplayerToken() {
        return this.multiplayerToken;
    }

    public KeyPair getSessionKeyPair() {
        return this.sessionKeyPair;
    }

    public UUID getDeviceId() {
        return this.deviceId;
    }

    public String getSelfSignedJwt() {
        return this.selfSignedJwt;
    }

    public void setSelfSignedJwt(String selfSignedJwt) {
        this.selfSignedJwt = selfSignedJwt;
    }

    public String getSkinJwt() {
        return this.skinJwt;
    }

    public void setSkinJwt(String skinJwt) {
        this.skinJwt = skinJwt;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getXuid() {
        return this.xuid;
    }

    public void setXuid(String xuid) {
        this.xuid = xuid;
    }

    public List<String> getCertificateChain() {
        ArrayList<String> chain = new ArrayList<String>();
        if (this.selfSignedJwt != null) {
            chain.add(this.selfSignedJwt);
        }
        if (this.mojangJwt != null) {
            chain.add(this.mojangJwt);
        }
        if (this.identityJwt != null) {
            chain.add(this.identityJwt);
        }
        return chain;
    }
}

