/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.google.common.collect.Iterables;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.protocols.v1_21_7to1_21_9.packet.ClientboundPackets1_21_9;
import com.viaversion.viaversion.util.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.logging.Level;
import net.lenni0451.mcstructs_bedrock.text.utils.BedrockTranslator;
import net.lenni0451.mcstructs_bedrock.text.utils.TranslatorOptions;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.brigadier.BedrockLiteralCommandNode;
import net.raphimc.viabedrock.api.brigadier.BlockPositionArgumentType;
import net.raphimc.viabedrock.api.brigadier.BlockStatesArgumentType;
import net.raphimc.viabedrock.api.brigadier.CompareOperatorArgumentType;
import net.raphimc.viabedrock.api.brigadier.EnumArgumentType;
import net.raphimc.viabedrock.api.brigadier.EquipmentSlotArgumentType;
import net.raphimc.viabedrock.api.brigadier.IntegerRangeArgumentType;
import net.raphimc.viabedrock.api.brigadier.JsonArgumentType;
import net.raphimc.viabedrock.api.brigadier.OperatorArgumentType;
import net.raphimc.viabedrock.api.brigadier.PositionArgumentType;
import net.raphimc.viabedrock.api.brigadier.SuggestionsUtil;
import net.raphimc.viabedrock.api.brigadier.TargetArgumentType;
import net.raphimc.viabedrock.api.brigadier.ValueArgumentType;
import net.raphimc.viabedrock.api.brigadier.WildcardIntegerArgumentType;
import net.raphimc.viabedrock.api.util.PacketFactory;
import net.raphimc.viabedrock.api.util.TextUtil;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.ArgumentTypeRegistry;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.CommandParameterOption;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.CommandPermissionLevel;
import net.raphimc.viabedrock.protocol.model.CommandData;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;
import net.raphimc.viabedrock.protocol.storage.GameSessionStorage;
import net.raphimc.viabedrock.protocol.storage.ResourcePacksStorage;

public class CommandsStorage
extends StoredObject {
    private static final byte TYPE_LITERAL = 1;
    private static final byte TYPE_ARGUMENT = 2;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_REDIRECT = 8;
    private static final byte FLAG_CUSTOM_SUGGESTIONS = 16;
    private static final String ASK_SERVER_SUGGESTION_TYPE = "minecraft:ask_server";
    public static final int RESULT_ALLOW_SEND = -1;
    public static final int RESULT_NO_OP = 0;
    public static final int RESULT_CANCEL = 1;
    private static final Command<UserConnection> ALLOW_SEND = cmd -> -1;
    private static final Command<UserConnection> NOOP = cmd -> 0;
    private final CommandData[] commands;
    private final Map<String, CommandData.EnumData> softEnumMap = new HashMap<String, CommandData.EnumData>();
    private CommandDispatcher<UserConnection> dispatcher;

    public CommandsStorage(UserConnection user, CommandData[] commands) {
        super(user);
        for (CommandData command : this.commands = commands) {
            for (CommandData.OverloadData overload : command.overloads()) {
                for (CommandData.OverloadData.ParamData parameter : overload.parameters()) {
                    if (parameter.enumData() == null || !parameter.enumData().soft()) continue;
                    this.softEnumMap.put(parameter.enumData().name(), parameter.enumData());
                }
            }
        }
    }

    public void updateCommandTree() {
        PacketWrapper commands = PacketWrapper.create((PacketType)ClientboundPackets1_21_9.COMMANDS, (UserConnection)this.user());
        this.writeCommandTree(commands);
        commands.send(BedrockProtocol.class);
    }

    public void writeCommandTree(PacketWrapper wrapper) {
        this.buildCommandTree();
        RootCommandNode root = this.dispatcher.getRoot();
        Map<CommandNode<UserConnection>, Integer> nodeIndices = this.getNodeIndices((RootCommandNode<UserConnection>)root);
        ArrayList<CommandNode<UserConnection>> nodes = new ArrayList<CommandNode<UserConnection>>(nodeIndices.keySet());
        nodes.sort(Comparator.comparingInt(nodeIndices::get));
        wrapper.write((Type)Types.VAR_INT, (Object)nodes.size());
        for (CommandNode commandNode : nodes) {
            byte flags = 0;
            if (commandNode.getRedirect() != null) {
                flags = (byte)(flags | 8);
            }
            if (commandNode.getCommand() != null) {
                flags = (byte)(flags | 4);
            }
            if (commandNode instanceof LiteralCommandNode) {
                flags = (byte)(flags | 1);
            } else if (commandNode instanceof ArgumentCommandNode) {
                ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)commandNode;
                flags = (byte)(flags | 2);
                if (argumentCommandNode.getCustomSuggestions() != null) {
                    flags = (byte)(flags | 0x10);
                }
            } else if (!(commandNode instanceof RootCommandNode)) {
                throw new UnsupportedOperationException("Unsupported node type: " + commandNode.getClass().getName());
            }
            wrapper.write((Type)Types.BYTE, (Object)flags);
            wrapper.write(Types.VAR_INT_ARRAY_PRIMITIVE, (Object)commandNode.getChildren().stream().mapToInt(nodeIndices::get).toArray());
            if (commandNode.getRedirect() != null) {
                wrapper.write((Type)Types.VAR_INT, (Object)nodeIndices.get(commandNode.getRedirect()));
            }
            if (commandNode instanceof LiteralCommandNode) {
                LiteralCommandNode literalCommandNode = (LiteralCommandNode)commandNode;
                wrapper.write(Types.STRING, (Object)literalCommandNode.getLiteral());
                continue;
            }
            if (!(commandNode instanceof ArgumentCommandNode)) continue;
            ArgumentCommandNode argumentCommandNode = (ArgumentCommandNode)commandNode;
            ArgumentTypeRegistry.ArgumentTypeMapping mapping = ArgumentTypeRegistry.getArgumentTypeMapping(argumentCommandNode.getType());
            wrapper.write(Types.STRING, (Object)argumentCommandNode.getName());
            wrapper.write((Type)Types.VAR_INT, (Object)mapping.id());
            if (mapping.writer() != null) {
                mapping.writer().accept(wrapper, argumentCommandNode.getType());
            }
            if (argumentCommandNode.getCustomSuggestions() == null) continue;
            wrapper.write(Types.STRING, (Object)ASK_SERVER_SUGGESTION_TYPE);
        }
        wrapper.write((Type)Types.VAR_INT, (Object)nodeIndices.get(root));
    }

    public Suggestions complete(String message) {
        StringReader reader = new StringReader(message);
        if (reader.canRead() && reader.peek() == '/') {
            reader.skip();
        }
        ParseResults parseResults = this.dispatcher.parse(reader, (Object)this.user());
        return (Suggestions)this.dispatcher.getCompletionSuggestions(parseResults).join();
    }

    public int execute(String message) {
        StringReader reader = new StringReader(message);
        if (reader.canRead() && reader.peek() == '/') {
            reader.skip();
        }
        ParseResults parseResults = this.dispatcher.parse(reader, (Object)this.user());
        try {
            return this.dispatcher.execute(parseResults);
        }
        catch (Throwable ignored) {
            if (!parseResults.getContext().getNodes().isEmpty()) {
                return -1;
            }
            return 0;
        }
    }

    public CommandData.EnumData getSoftEnum(String name) {
        return this.softEnumMap.get(name);
    }

    private void buildCommandTree() {
        this.dispatcher = new CommandDispatcher();
        GameSessionStorage gameSession = (GameSessionStorage)this.user().get(GameSessionStorage.class);
        EntityTracker entityTracker = (EntityTracker)this.user().get(EntityTracker.class);
        byte playerCommandPermission = entityTracker.getClientPlayer().abilities().commandPermission();
        Command<UserConnection> action = gameSession.areCommandsEnabled() ? NOOP : ALLOW_SEND;
        for (CommandData command : this.commands) {
            String name;
            String string = name = command.alias() != null ? (String)Iterables.getFirst(command.alias().values().keySet(), null) : command.name();
            if (name == null || playerCommandPermission < command.permission() || (command.flags() & 2) != 0 && (command.flags() & 4) != 0 && (command.flags() & 8) != 0 || !gameSession.areCommandsEnabled() && (command.flags() & 0x80) == 0) continue;
            LiteralArgumentBuilder<UserConnection> cmdBuilder = CommandsStorage.literal(name);
            for (CommandData.OverloadData overload : command.overloads()) {
                Object last = null;
                boolean hasRedirect = false;
                block22: for (int i = overload.parameters().length - 1; i >= 0; --i) {
                    RequiredArgumentBuilder argument;
                    CommandData.OverloadData.ParamData parameter = overload.parameters()[i];
                    if (parameter.enumData() != null) {
                        if ((parameter.flags() & CommandParameterOption.EnumAsChainedCommand.getValue()) != 0) {
                            throw new UnsupportedOperationException("Enum as chained command is not supported yet");
                        }
                        if ((parameter.flags() & CommandParameterOption.HasSemanticConstraint.getValue()) != 0) {
                            HashMap<String, Set<Byte>> enumDataValues = new HashMap<String, Set<Byte>>(parameter.enumData().values());
                            enumDataValues.entrySet().removeIf(entry -> {
                                if (((Set)entry.getValue()).contains((byte)0) && !gameSession.areCommandsEnabled()) {
                                    return true;
                                }
                                if (((Set)entry.getValue()).contains((byte)1) && playerCommandPermission < CommandPermissionLevel.GameDirectors.getValue()) {
                                    return true;
                                }
                                return ((Set)entry.getValue()).contains((byte)2) && playerCommandPermission < CommandPermissionLevel.Host.getValue();
                            });
                            HashSet<String> values = new HashSet<String>(enumDataValues.keySet());
                            enumDataValues.entrySet().removeIf(entry -> ((Set)entry.getValue()).contains((byte)3));
                            argumentType = EnumArgumentType.valuesAndCompletions(values, enumDataValues.keySet());
                        } else {
                            argumentType = (parameter.flags() & CommandParameterOption.EnumAutocompleteExpansion.getValue()) != 0 ? EnumArgumentType.values(parameter.enumData().values().keySet()) : EnumArgumentType.values(parameter.enumData().values().keySet());
                        }
                        argument = CommandsStorage.argument(parameter.name() + ": " + parameter.enumData().name(), argumentType).suggests((arg_0, arg_1) -> ((ArgumentType)argumentType).listSuggestions(arg_0, arg_1));
                    } else {
                        if (parameter.subCommandData() != null || parameter.postfix() != null) continue;
                        if (parameter.type() != null) {
                            argumentType = null;
                            switch (parameter.type()) {
                                case Int: {
                                    argument = CommandsStorage.argument(parameter.name() + ": int", IntegerArgumentType.integer());
                                    break;
                                }
                                case Float: 
                                case Val: {
                                    argument = CommandsStorage.argument(parameter.name() + ": float", FloatArgumentType.floatArg());
                                    break;
                                }
                                case RVal: {
                                    argumentType = ValueArgumentType.value();
                                    argument = CommandsStorage.argument(parameter.name() + ": value", argumentType);
                                    break;
                                }
                                case WildcardInt: {
                                    argumentType = WildcardIntegerArgumentType.wildcardInteger();
                                    argument = CommandsStorage.argument(parameter.name() + ": wildcard int", argumentType);
                                    break;
                                }
                                case Operator: {
                                    argument = CommandsStorage.argument(parameter.name() + ": operator", OperatorArgumentType.operator());
                                    break;
                                }
                                case CompareOperator: {
                                    argumentType = CompareOperatorArgumentType.compareOperator();
                                    argument = CommandsStorage.argument(parameter.name() + ": compare operator", argumentType);
                                    break;
                                }
                                case Selection: 
                                case WildcardSelection: {
                                    argumentType = TargetArgumentType.target();
                                    argument = CommandsStorage.argument(parameter.name() + ": target", argumentType);
                                    break;
                                }
                                case FilePath: {
                                    argument = CommandsStorage.argument(parameter.name() + ": filepath", StringArgumentType.string());
                                    break;
                                }
                                case FullIntegerRange: {
                                    argumentType = IntegerRangeArgumentType.integerRange();
                                    argument = CommandsStorage.argument(parameter.name() + ": integer range", argumentType);
                                    break;
                                }
                                case EquipmentSlotEnum: {
                                    argumentType = EquipmentSlotArgumentType.equipmentSlot();
                                    argument = CommandsStorage.argument(parameter.name() + ": equipment slots", argumentType);
                                    break;
                                }
                                case Id: {
                                    argument = CommandsStorage.argument(parameter.name() + ": string", StringArgumentType.string());
                                    break;
                                }
                                case Position: {
                                    argument = CommandsStorage.argument(parameter.name() + ": x y z", BlockPositionArgumentType.blockPosition());
                                    break;
                                }
                                case PositionFloat: {
                                    argument = CommandsStorage.argument(parameter.name() + ": x y z", PositionArgumentType.position());
                                    break;
                                }
                                case MessageRoot: {
                                    argument = CommandsStorage.argument(parameter.name() + ": message", StringArgumentType.greedyString());
                                    break;
                                }
                                case RawText: {
                                    argument = CommandsStorage.argument(parameter.name() + ": text", StringArgumentType.greedyString());
                                    break;
                                }
                                case JsonObject: {
                                    argumentType = JsonArgumentType.json();
                                    argument = CommandsStorage.argument(parameter.name() + ": json", argumentType);
                                    break;
                                }
                                case BlockStateArray: {
                                    argumentType = BlockStatesArgumentType.blockStates();
                                    argument = CommandsStorage.argument(parameter.name() + ": block states", argumentType);
                                    break;
                                }
                                case SlashCommand: {
                                    hasRedirect = true;
                                    last = null;
                                    continue block22;
                                }
                                default: {
                                    ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Unhandled command parameter type: " + String.valueOf((Object)parameter.type()));
                                    argument = CommandsStorage.argument(parameter.name() + ": unknown", StringArgumentType.greedyString());
                                }
                            }
                            if (argumentType != null) {
                                argument.suggests((arg_0, arg_1) -> ((ArgumentType)argumentType).listSuggestions(arg_0, arg_1));
                            }
                        } else {
                            ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Invalid command parameter: " + String.valueOf(parameter));
                            argument = CommandsStorage.argument(parameter.name() + ": unknown", StringArgumentType.greedyString());
                        }
                    }
                    if (hasRedirect) {
                        argument.redirect((CommandNode)this.dispatcher.getRoot());
                        hasRedirect = false;
                    } else if (last != null) {
                        argument.then(last);
                        if (overload.parameters()[i + 1].optional()) {
                            argument.executes(action);
                        }
                    } else {
                        argument.executes(action);
                    }
                    last = argument;
                }
                if (hasRedirect) {
                    cmdBuilder.redirect((CommandNode)this.dispatcher.getRoot());
                    continue;
                }
                if (last != null) {
                    cmdBuilder.then(last);
                    continue;
                }
                cmdBuilder.executes(action);
            }
            BedrockLiteralCommandNode node = new BedrockLiteralCommandNode(command, cmdBuilder.build());
            this.dispatcher.getRoot().addChild(node);
            if (command.alias() == null || command.alias().values().size() <= 1) continue;
            for (String alias : command.alias().values().keySet()) {
                if (alias.equals(node.getName())) continue;
                this.dispatcher.register((LiteralArgumentBuilder)CommandsStorage.literal(alias).redirect(node));
            }
        }
        if (this.dispatcher.getRoot().getChild("help") == null) {
            ResourcePacksStorage resourcePacksStorage = (ResourcePacksStorage)this.user().get(ResourcePacksStorage.class);
            Function<String, String> translator = resourcePacksStorage.getTexts().lookup();
            LiteralArgumentBuilder<UserConnection> cmdBuilder = CommandsStorage.literal("help");
            cmdBuilder.executes(cmd -> {
                PacketFactory.sendJavaSystemChat((UserConnection)cmd.getSource(), TextUtil.stringToNbt("\u00a7c" + BedrockTranslator.translate((String)"%commands.generic.usage", (Function)translator, (Object[])new Object[]{"/help <command>"}, (TranslatorOptions[])new TranslatorOptions[0])));
                return 1;
            });
            cmdBuilder.then(CommandsStorage.argument("command", StringArgumentType.greedyString()).suggests((context, builder) -> SuggestionsUtil.suggestMatching(this.dispatcher.getRoot().getChildren().stream().map(c -> {
                String description = c instanceof BedrockLiteralCommandNode ? ((BedrockLiteralCommandNode)((Object)((Object)c))).getCommandData().description() : (c.getName().equals("help") || c.getName().equals("?") ? "commands.help.description" : null);
                return new Pair((Object)c.getName(), description != null ? BedrockTranslator.translate((String)description, (Function)translator, (Object[])new Object[0], (TranslatorOptions[])new TranslatorOptions[]{TranslatorOptions.IGNORE_STARTING_PERCENT}) : null);
            }), builder)).executes(cmd -> {
                String commandName = StringArgumentType.getString((CommandContext)cmd, (String)"command");
                CommandNode node = this.dispatcher.getRoot().getChild(commandName);
                ArrayList<Object> lines = new ArrayList<Object>();
                if (node != null) {
                    while (node.getRedirect() != null) {
                        node = node.getRedirect();
                    }
                    lines.add(resourcePacksStorage.getTexts().get("commands.generic.usage.noparam"));
                    String[] usage = this.dispatcher.getAllUsage(node, (Object)((UserConnection)cmd.getSource()), true);
                    if (usage.length == 0) {
                        lines.add("- /" + node.getName());
                    } else {
                        void var8_9;
                        boolean bl = false;
                        while (var8_9 < usage.length) {
                            usage[var8_9] = "- /" + node.getName() + " " + usage[var8_9];
                            ++var8_9;
                        }
                    }
                    Collections.addAll(lines, usage);
                } else {
                    lines.add("\u00a7c" + BedrockTranslator.translate((String)"%commands.generic.unknown", (Function)translator, (Object[])new Object[]{commandName}, (TranslatorOptions[])new TranslatorOptions[0]));
                }
                for (String string : lines) {
                    PacketFactory.sendJavaSystemChat((UserConnection)cmd.getSource(), TextUtil.stringToNbt(string));
                }
                return 1;
            }));
            this.dispatcher.register((LiteralArgumentBuilder)CommandsStorage.literal("?").redirect((CommandNode)this.dispatcher.register(cmdBuilder)));
        }
    }

    private Map<CommandNode<UserConnection>, Integer> getNodeIndices(RootCommandNode<UserConnection> root) {
        CommandNode node;
        HashMap<CommandNode<UserConnection>, Integer> nodes = new HashMap<CommandNode<UserConnection>, Integer>();
        ArrayDeque<Object> queue = new ArrayDeque<Object>();
        queue.add(root);
        while ((node = (CommandNode)queue.poll()) != null) {
            if (nodes.containsKey(node)) continue;
            nodes.put((CommandNode<UserConnection>)node, nodes.size());
            queue.addAll(node.getChildren());
            if (node.getRedirect() == null) continue;
            queue.add(node.getRedirect());
        }
        return nodes;
    }

    private static LiteralArgumentBuilder<UserConnection> literal(String literal) {
        return LiteralArgumentBuilder.literal((String)literal);
    }

    private static <T> RequiredArgumentBuilder<UserConnection, T> argument(String name, ArgumentType<T> type) {
        return RequiredArgumentBuilder.argument((String)name, type);
    }
}

