/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.storage;

import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.State;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import net.raphimc.viabedrock.ViaBedrock;
import net.raphimc.viabedrock.api.model.entity.ClientPlayerEntity;
import net.raphimc.viabedrock.api.util.PacketFactory;
import net.raphimc.viabedrock.protocol.BedrockProtocol;
import net.raphimc.viabedrock.protocol.data.enums.java.EntityEvent;
import net.raphimc.viabedrock.protocol.data.enums.java.GameEventType;
import net.raphimc.viabedrock.protocol.model.GameRule;
import net.raphimc.viabedrock.protocol.storage.EntityTracker;

public class GameRulesStorage
extends StoredObject {
    private final Map<String, Object> gameRules = new HashMap<String, Object>(BedrockProtocol.MAPPINGS.getBedrockGameRules());

    public GameRulesStorage(UserConnection user, GameRule[] gameRules) {
        super(user);
        this.updateGameRules(gameRules);
    }

    public void updateGameRules(GameRule[] gameRules) {
        State state = this.user().getProtocolInfo().getServerState();
        for (GameRule gameRule : gameRules) {
            if (gameRule.value() == null) continue;
            Object previousValue = this.gameRules.put(gameRule.name().toLowerCase(Locale.ROOT), gameRule.value());
            if (previousValue == null) {
                ViaBedrock.getPlatform().getLogger().log(Level.WARNING, "Received unknown game rule: " + gameRule.name());
                continue;
            }
            if (previousValue == gameRule.value() || state != State.PLAY) continue;
            if (gameRule.name().equalsIgnoreCase("showCoordinates") && ViaBedrock.getConfig().shouldTranslateShowCoordinatesGameRule()) {
                ClientPlayerEntity clientPlayer = ((EntityTracker)this.user().get(EntityTracker.class)).getClientPlayer();
                PacketFactory.sendJavaEntityEvent(this.user(), clientPlayer, (Boolean)gameRule.value() != false ? EntityEvent.FULL_DEBUG_INFO : EntityEvent.REDUCED_DEBUG_INFO);
                continue;
            }
            if (gameRule.name().equalsIgnoreCase("doImmediateRespawn")) {
                PacketFactory.sendJavaGameEvent(this.user(), GameEventType.IMMEDIATE_RESPAWN, (Boolean)gameRule.value() != false ? 1.0f : 0.0f);
                continue;
            }
            if (!gameRule.name().equalsIgnoreCase("doLimitedCrafting")) continue;
            PacketFactory.sendJavaGameEvent(this.user(), GameEventType.LIMITED_CRAFTING, (Boolean)gameRule.value() != false ? 1.0f : 0.0f);
        }
    }

    public <T> T getGameRule(String name) {
        return (T)this.gameRules.get(name.toLowerCase(Locale.ROOT));
    }
}

