/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.entitydata;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntMap;
import com.viaversion.viaversion.libs.fastutil.ints.Int2IntOpenHashMap;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import net.raphimc.viabedrock.protocol.model.EntityProperties;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class EntityPropertiesType
extends Type<EntityProperties> {
    public EntityPropertiesType() {
        super("EntityProperties", EntityProperties.class);
    }

    public EntityProperties read(ByteBuf buffer) {
        int intPropertiesLength = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(buffer);
        Int2IntOpenHashMap intProperties = new Int2IntOpenHashMap(intPropertiesLength);
        for (int i = 0; i < intPropertiesLength; ++i) {
            int index = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(buffer);
            int value = BedrockTypes.VAR_INT.readPrimitive(buffer);
            intProperties.put(index, value);
        }
        int floatPropertiesLength = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(buffer);
        HashMap<Integer, Float> floatProperties = new HashMap<Integer, Float>(floatPropertiesLength);
        for (int i = 0; i < floatPropertiesLength; ++i) {
            int index = BedrockTypes.UNSIGNED_VAR_INT.readPrimitive(buffer);
            float value = BedrockTypes.FLOAT_LE.readPrimitive(buffer);
            floatProperties.put(index, Float.valueOf(value));
        }
        return new EntityProperties((Int2IntMap)intProperties, floatProperties);
    }

    public void write(ByteBuf buffer, EntityProperties value) {
        BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(buffer, value.intProperties().size());
        value.intProperties().forEach((i, v) -> {
            BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(buffer, (int)i);
            BedrockTypes.VAR_INT.writePrimitive(buffer, (int)v);
        });
        BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(buffer, value.floatProperties().size());
        value.floatProperties().forEach((i, v) -> {
            BedrockTypes.UNSIGNED_VAR_INT.writePrimitive(buffer, (int)i);
            BedrockTypes.FLOAT_LE.writePrimitive(buffer, v.floatValue());
        });
    }
}

