/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.viabedrock.protocol.types.model;

import com.viaversion.viaversion.api.type.Type;
import io.netty.buffer.ByteBuf;
import net.raphimc.viabedrock.protocol.data.enums.bedrock.generated.GameRule_Type;
import net.raphimc.viabedrock.protocol.model.GameRule;
import net.raphimc.viabedrock.protocol.types.BedrockTypes;

public class GameRuleType
extends Type<GameRule> {
    private final boolean varInt;

    public GameRuleType(boolean varInt) {
        super(GameRule.class);
        this.varInt = varInt;
    }

    public GameRule read(ByteBuf buffer) {
        String name = (String)BedrockTypes.STRING.read(buffer);
        boolean editable = buffer.readBoolean();
        GameRule_Type type = GameRule_Type.getByValue(BedrockTypes.UNSIGNED_VAR_INT.read(buffer), GameRule_Type.Invalid);
        return switch (type) {
            case GameRule_Type.Bool -> new GameRule(name, editable, buffer.readBoolean());
            case GameRule_Type.Int -> new GameRule(name, editable, this.varInt ? BedrockTypes.VAR_INT.readPrimitive(buffer) : BedrockTypes.INT_LE.readPrimitive(buffer));
            case GameRule_Type.Float -> new GameRule(name, editable, Float.valueOf(BedrockTypes.FLOAT_LE.readPrimitive(buffer)));
            case GameRule_Type.Invalid -> new GameRule(name, editable, null);
            default -> throw new IllegalStateException("Unhandled GameRule_Type: " + String.valueOf((Object)type));
        };
    }

    public void write(ByteBuf buffer, GameRule value) {
        Class<?> valueClass;
        BedrockTypes.STRING.write(buffer, (Object)value.name());
        buffer.writeBoolean(value.editable());
        Class<?> clazz = valueClass = value.value() == null ? null : value.value().getClass();
        GameRule_Type type = valueClass == Boolean.class ? GameRule_Type.Bool : (valueClass == Integer.class ? GameRule_Type.Int : (valueClass == Float.class ? GameRule_Type.Float : GameRule_Type.Invalid));
        BedrockTypes.UNSIGNED_VAR_INT.write(buffer, type.getValue());
        switch (type) {
            case Bool: {
                buffer.writeBoolean(((Boolean)value.value()).booleanValue());
                break;
            }
            case Int: {
                if (this.varInt) {
                    BedrockTypes.VAR_INT.writePrimitive(buffer, (Integer)value.value());
                    break;
                }
                BedrockTypes.INT_LE.writePrimitive(buffer, (Integer)value.value());
                break;
            }
            case Float: {
                BedrockTypes.FLOAT_LE.writePrimitive(buffer, ((Float)value.value()).floatValue());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled GameRule_Type: " + String.valueOf((Object)type));
            }
        }
    }
}

