/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.DecoderException;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.raphimc.netminecraft.constants.MCPipeline;
import net.raphimc.netminecraft.packet.PacketTypes;
import net.raphimc.netminecraft.packet.registry.PacketRegistry;

public class PacketCompressor
extends ByteToMessageCodec<ByteBuf> {
    private static final int MAX_UNCOMPRESSED_SIZE_1_7_2 = 0x200000;
    private static final int MAX_UNCOMPRESSED_SIZE_1_17_1 = 0x800000;
    private final byte[] deflateBuffer = new byte[8192];
    private Deflater deflater;
    private Inflater inflater;

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        super.handlerRemoved(ctx);
        if (this.inflater != null) {
            this.inflater.end();
        }
        if (this.deflater != null) {
            this.deflater.end();
        }
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if ((Integer)ctx.channel().attr(MCPipeline.COMPRESSION_THRESHOLD_ATTRIBUTE_KEY).get() < 0) {
            out.add(in.readBytes(in.readableBytes()));
            return;
        }
        if (this.inflater == null) {
            this.inflater = new Inflater();
        }
        if (in.readableBytes() != 0) {
            int uncompressedLength = PacketTypes.readVarInt(in);
            if (uncompressedLength == 0) {
                out.add(in.readBytes(in.readableBytes()));
            } else {
                if (uncompressedLength < (Integer)ctx.channel().attr(MCPipeline.COMPRESSION_THRESHOLD_ATTRIBUTE_KEY).get()) {
                    throw new DecoderException("Badly compressed packet - size of " + uncompressedLength + " is below server threshold of " + ctx.channel().attr(MCPipeline.COMPRESSION_THRESHOLD_ATTRIBUTE_KEY).get());
                }
                int maxUncompressedSize = this.getMaxUncompressedSize(ctx.channel());
                if (uncompressedLength > maxUncompressedSize) {
                    throw new DecoderException("Badly compressed packet - size of " + uncompressedLength + " is larger than protocol maximum of " + maxUncompressedSize);
                }
                byte[] compressedData = new byte[in.readableBytes()];
                in.readBytes(compressedData);
                this.inflater.setInput(compressedData);
                byte[] uncompressedData = new byte[uncompressedLength];
                this.inflater.inflate(uncompressedData);
                out.add(in.alloc().buffer().writeBytes(uncompressedData));
                this.inflater.reset();
            }
        }
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
        int packetSize;
        if ((Integer)ctx.channel().attr(MCPipeline.COMPRESSION_THRESHOLD_ATTRIBUTE_KEY).get() < 0) {
            out.writeBytes(in);
            return;
        }
        if (this.deflater == null) {
            this.deflater = new Deflater();
        }
        if ((packetSize = in.readableBytes()) < (Integer)ctx.channel().attr(MCPipeline.COMPRESSION_THRESHOLD_ATTRIBUTE_KEY).get()) {
            PacketTypes.writeVarInt(out, 0);
            out.writeBytes(in);
        } else {
            int maxUncompressedSize = this.getMaxUncompressedSize(ctx.channel());
            if (packetSize > maxUncompressedSize) {
                throw new IllegalArgumentException("Packet too big (is " + packetSize + ", should be less than " + maxUncompressedSize + ")");
            }
            byte[] uncompressedData = new byte[packetSize];
            in.readBytes(uncompressedData);
            PacketTypes.writeVarInt(out, uncompressedData.length);
            this.deflater.setInput(uncompressedData, 0, packetSize);
            this.deflater.finish();
            while (!this.deflater.finished()) {
                out.writeBytes(this.deflateBuffer, 0, this.deflater.deflate(this.deflateBuffer));
            }
            this.deflater.reset();
        }
    }

    private int getMaxUncompressedSize(Channel channel) {
        int maxUncompressedSize = 0x800000;
        PacketRegistry packetRegistry = (PacketRegistry)channel.attr(MCPipeline.PACKET_REGISTRY_ATTRIBUTE_KEY).get();
        if (packetRegistry != null && packetRegistry.getProtocolVersion() < 756) {
            maxUncompressedSize = 0x200000;
        }
        return maxUncompressedSize;
    }
}

