/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.DecoderException;
import io.netty.util.ByteProcessor;
import java.util.List;
import net.raphimc.netminecraft.netty.sizer.VarIntByteDecoder;
import net.raphimc.netminecraft.packet.PacketTypes;

public class OptimizedPacketSizer
extends ByteToMessageCodec<ByteBuf> {
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (!ctx.channel().isActive()) {
            in.clear();
            return;
        }
        VarIntByteDecoder reader = new VarIntByteDecoder();
        int varintEnd = in.forEachByte((ByteProcessor)reader);
        if (varintEnd == -1) {
            if (reader.getResult() == VarIntByteDecoder.DecodeResult.RUN_OF_ZEROES) {
                in.clear();
            }
            return;
        }
        if (reader.getResult() == VarIntByteDecoder.DecodeResult.RUN_OF_ZEROES) {
            in.readerIndex(varintEnd);
        } else if (reader.getResult() == VarIntByteDecoder.DecodeResult.SUCCESS) {
            int readVarint = reader.getReadVarint();
            int bytesRead = reader.getBytesRead();
            if (readVarint < 0) {
                in.clear();
                throw new DecoderException("Bad packet length");
            }
            if (readVarint == 0) {
                in.readerIndex(varintEnd + 1);
            } else {
                int minimumRead = bytesRead + readVarint;
                if (in.isReadable(minimumRead)) {
                    out.add(in.retainedSlice(varintEnd + 1, readVarint));
                    in.skipBytes(minimumRead);
                }
            }
        } else if (reader.getResult() == VarIntByteDecoder.DecodeResult.TOO_BIG) {
            in.clear();
            throw new DecoderException("VarInt too big");
        }
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
        PacketTypes.writeVarInt(out, in.readableBytes());
        out.writeBytes(in);
    }
}

