/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.constants;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.util.AttributeKey;
import java.util.function.Supplier;
import net.raphimc.netminecraft.netty.codec.NoReadFlowControlHandler;
import net.raphimc.netminecraft.netty.codec.OptimizedPacketSizer;
import net.raphimc.netminecraft.netty.codec.PacketCodec;
import net.raphimc.netminecraft.netty.codec.PacketCompressor;
import net.raphimc.netminecraft.netty.codec.PacketCryptor;
import net.raphimc.netminecraft.netty.codec.PacketSizer;
import net.raphimc.netminecraft.netty.crypto.AESEncryption;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.registry.PacketRegistry;

public class MCPipeline {
    public static final String ENCRYPTION_HANDLER_NAME = "encryption";
    public static final String SIZER_HANDLER_NAME = "sizer";
    public static final String FLOW_CONTROL_HANDLER_NAME = "flow-control";
    public static final String COMPRESSION_HANDLER_NAME = "compression";
    public static final String PACKET_CODEC_HANDLER_NAME = "packet-codec";
    public static final String HANDLER_HANDLER_NAME = "handler";
    public static final AttributeKey<Integer> COMPRESSION_THRESHOLD_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"compression_threshold");
    public static final AttributeKey<AESEncryption> ENCRYPTION_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"encryption");
    public static final AttributeKey<PacketRegistry> PACKET_REGISTRY_ATTRIBUTE_KEY = AttributeKey.valueOf((String)"packet_registry");
    public static final Supplier<ByteToMessageCodec<ByteBuf>> DEFAULT_ENCRYPTION_HANDLER = PacketCryptor::new;
    public static final Supplier<ByteToMessageCodec<ByteBuf>> DEFAULT_SIZER_HANDLER = PacketSizer::new;
    public static final Supplier<ChannelHandler> DEFAULT_FLOW_CONTROL_HANDLER = NoReadFlowControlHandler::new;
    public static final Supplier<ByteToMessageCodec<ByteBuf>> DEFAULT_COMPRESSION_HANDLER = PacketCompressor::new;
    public static final Supplier<ByteToMessageCodec<Packet>> DEFAULT_PACKET_CODEC_HANDLER = PacketCodec::new;
    public static final Supplier<ByteToMessageCodec<ByteBuf>> OPTIMIZED_SIZER_HANDLER = OptimizedPacketSizer::new;
    public static Supplier<ByteToMessageCodec<ByteBuf>> ENCRYPTION_HANDLER;
    public static Supplier<ByteToMessageCodec<ByteBuf>> SIZER_HANDLER;
    public static Supplier<ChannelHandler> FLOW_CONTROL_HANDLER;
    public static Supplier<ByteToMessageCodec<ByteBuf>> COMPRESSION_HANDLER;
    public static Supplier<ByteToMessageCodec<Packet>> PACKET_CODEC_HANDLER;

    public static void useDefaultPipeline() {
        ENCRYPTION_HANDLER = DEFAULT_ENCRYPTION_HANDLER;
        SIZER_HANDLER = DEFAULT_SIZER_HANDLER;
        FLOW_CONTROL_HANDLER = DEFAULT_FLOW_CONTROL_HANDLER;
        COMPRESSION_HANDLER = DEFAULT_COMPRESSION_HANDLER;
        PACKET_CODEC_HANDLER = DEFAULT_PACKET_CODEC_HANDLER;
    }

    public static void useOptimizedPipeline() {
        MCPipeline.useDefaultPipeline();
        SIZER_HANDLER = OPTIMIZED_SIZER_HANDLER;
    }

    static {
        MCPipeline.useDefaultPipeline();
    }
}

