/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.netty.connection;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import java.net.SocketAddress;
import net.raphimc.netminecraft.util.EventLoops;
import net.raphimc.netminecraft.util.TransportType;

public class NetClient {
    protected final ChannelInitializer<Channel> channelInitializer;
    protected ChannelFuture channelFuture;

    public NetClient(ChannelInitializer<Channel> channelInitializer) {
        this.channelInitializer = channelInitializer;
    }

    public void initialize(TransportType transportType, Bootstrap bootstrap) {
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)bootstrap.group((EventLoopGroup)EventLoops.getClientEventLoop(transportType))).channel(transportType.tcpClientChannelClass())).option(ChannelOption.TCP_NODELAY, (Object)true)).option(ChannelOption.SO_KEEPALIVE, (Object)true)).handler(this.channelInitializer);
        this.channelFuture = bootstrap.register().syncUninterruptibly();
    }

    public ChannelFuture connect(SocketAddress address) {
        if (this.channelFuture == null) {
            this.initialize(TransportType.getBest(address), new Bootstrap());
        }
        return this.getChannel().connect(address);
    }

    public Channel getChannel() {
        if (this.channelFuture == null) {
            return null;
        }
        return this.channelFuture.channel();
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }
}

