/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.util;

import io.netty.channel.Channel;
import io.netty.channel.IoHandlerFactory;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollDatagramChannel;
import io.netty.channel.epoll.EpollDomainDatagramChannel;
import io.netty.channel.epoll.EpollDomainSocketChannel;
import io.netty.channel.epoll.EpollIoHandler;
import io.netty.channel.epoll.EpollServerDomainSocketChannel;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.kqueue.KQueue;
import io.netty.channel.kqueue.KQueueDatagramChannel;
import io.netty.channel.kqueue.KQueueDomainDatagramChannel;
import io.netty.channel.kqueue.KQueueDomainSocketChannel;
import io.netty.channel.kqueue.KQueueIoHandler;
import io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import io.netty.channel.kqueue.KQueueServerSocketChannel;
import io.netty.channel.kqueue.KQueueSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalIoHandler;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioIoHandler;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.unix.DomainSocketAddress;
import io.netty.channel.uring.IoUringDatagramChannel;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringServerSocketChannel;
import io.netty.channel.uring.IoUringSocketChannel;
import java.net.SocketAddress;
import java.util.function.Supplier;

public enum TransportType {
    NIO(NioSocketChannel.class, NioDatagramChannel.class, NioServerSocketChannel.class, NioDatagramChannel.class, NioIoHandler::newFactory),
    EPOLL(EpollSocketChannel.class, EpollDatagramChannel.class, EpollServerSocketChannel.class, EpollDatagramChannel.class, EpollIoHandler::newFactory),
    KQUEUE(KQueueSocketChannel.class, KQueueDatagramChannel.class, KQueueServerSocketChannel.class, KQueueDatagramChannel.class, KQueueIoHandler::newFactory),
    IO_URING(IoUringSocketChannel.class, IoUringDatagramChannel.class, IoUringServerSocketChannel.class, IoUringDatagramChannel.class, IoUringIoHandler::newFactory),
    LOCAL(LocalChannel.class, LocalChannel.class, LocalServerChannel.class, LocalServerChannel.class, LocalIoHandler::newFactory),
    UNIX_EPOLL(EpollDomainSocketChannel.class, EpollDomainDatagramChannel.class, EpollServerDomainSocketChannel.class, EpollDomainDatagramChannel.class, EpollIoHandler::newFactory),
    UNIX_KQUEUE(KQueueDomainSocketChannel.class, KQueueDomainDatagramChannel.class, KQueueServerDomainSocketChannel.class, KQueueDomainDatagramChannel.class, KQueueIoHandler::newFactory);

    private final Class<? extends Channel> tcpClientChannelClass;
    private final Class<? extends Channel> udpClientChannelClass;
    private final Class<? extends ServerChannel> tcpServerChannelClass;
    private final Class<? extends Channel> udpServerChannelClass;
    private final Supplier<? extends IoHandlerFactory> ioHandlerFactorySupplier;

    public static TransportType getBest() {
        return TransportType.getBest(false);
    }

    public static TransportType getBest(SocketAddress address) {
        return TransportType.getBest(address instanceof DomainSocketAddress);
    }

    public static TransportType getBest(boolean unixAddress) {
        if (Epoll.isAvailable()) {
            if (unixAddress) {
                return UNIX_EPOLL;
            }
            return EPOLL;
        }
        if (KQueue.isAvailable()) {
            if (unixAddress) {
                return UNIX_KQUEUE;
            }
            return KQUEUE;
        }
        if (unixAddress) {
            throw new UnsupportedOperationException("Unix sockets are not supported on this platform");
        }
        return NIO;
    }

    private TransportType(Class<? extends Channel> tcpClientChannelClass, Class<? extends Channel> udpClientChannelClass, Class<? extends ServerChannel> tcpServerChannelClass, Class<? extends Channel> udpServerChannelClass, Supplier<? extends IoHandlerFactory> ioHandlerFactorySupplier) {
        this.tcpClientChannelClass = tcpClientChannelClass;
        this.udpClientChannelClass = udpClientChannelClass;
        this.tcpServerChannelClass = tcpServerChannelClass;
        this.udpServerChannelClass = udpServerChannelClass;
        this.ioHandlerFactorySupplier = ioHandlerFactorySupplier;
    }

    public Class<? extends Channel> tcpClientChannelClass() {
        return this.tcpClientChannelClass;
    }

    public Class<? extends Channel> udpClientChannelClass() {
        return this.udpClientChannelClass;
    }

    public Class<? extends ServerChannel> tcpServerChannelClass() {
        return this.tcpServerChannelClass;
    }

    public Class<? extends Channel> udpServerChannelClass() {
        return this.udpServerChannelClass;
    }

    public Supplier<? extends IoHandlerFactory> ioHandlerFactorySupplier() {
        return this.ioHandlerFactorySupplier;
    }
}

