/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import net.raphimc.netminecraft.constants.MCPipeline;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.PacketTypes;
import net.raphimc.netminecraft.packet.registry.PacketRegistry;

public class PacketCodec
extends ByteToMessageCodec<Packet> {
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        PacketRegistry packetRegistry = (PacketRegistry)ctx.channel().attr(MCPipeline.PACKET_REGISTRY_ATTRIBUTE_KEY).get();
        if (packetRegistry == null) {
            out.add(in.readBytes(in.readableBytes()));
            return;
        }
        if (in.readableBytes() != 0) {
            int packetId = PacketTypes.readVarInt(in);
            Packet packet = packetRegistry.createPacket(packetId, in);
            out.add(packet);
        }
    }

    protected void encode(ChannelHandlerContext ctx, Packet in, ByteBuf out) {
        PacketRegistry packetRegistry = (PacketRegistry)ctx.channel().attr(MCPipeline.PACKET_REGISTRY_ATTRIBUTE_KEY).get();
        if (packetRegistry == null) {
            throw new IllegalStateException("Can't write Packet without a packet registry");
        }
        PacketTypes.writeVarInt(out, packetRegistry.getPacketId(in));
        in.write(out, packetRegistry.getProtocolVersion());
    }
}

