/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import java.util.List;
import net.raphimc.netminecraft.constants.MCPipeline;
import net.raphimc.netminecraft.netty.crypto.AESEncryption;

public class PacketCryptor
extends ByteToMessageCodec<ByteBuf> {
    private byte[] decryptBuffer = new byte[0];
    private byte[] encryptBuffer = new byte[0];

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (ctx.channel().attr(MCPipeline.ENCRYPTION_ATTRIBUTE_KEY).get() == null) {
            out.add(in.readBytes(in.readableBytes()));
            return;
        }
        int length = in.readableBytes();
        byte[] bytes = this.getBytes(in);
        ByteBuf result = ctx.alloc().heapBuffer(((AESEncryption)ctx.channel().attr(MCPipeline.ENCRYPTION_ATTRIBUTE_KEY).get()).getDecryptOutputSize(length));
        result.writerIndex(((AESEncryption)ctx.channel().attr(MCPipeline.ENCRYPTION_ATTRIBUTE_KEY).get()).decrypt(bytes, 0, length, result.array(), result.arrayOffset()));
        out.add(result);
    }

    public void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) throws Exception {
        if (ctx.channel().attr(MCPipeline.ENCRYPTION_ATTRIBUTE_KEY).get() == null) {
            out.writeBytes(in);
            return;
        }
        int length = in.readableBytes();
        byte[] bytes = this.getBytes(in);
        int outLength = ((AESEncryption)ctx.channel().attr(MCPipeline.ENCRYPTION_ATTRIBUTE_KEY).get()).getEncryptOutputSize(length);
        if (this.encryptBuffer.length < outLength) {
            this.encryptBuffer = new byte[outLength];
        }
        out.writeBytes(this.encryptBuffer, 0, ((AESEncryption)ctx.channel().attr(MCPipeline.ENCRYPTION_ATTRIBUTE_KEY).get()).encrypt(bytes, 0, length, this.encryptBuffer, 0));
    }

    private byte[] getBytes(ByteBuf buf) {
        int length = buf.readableBytes();
        if (this.decryptBuffer.length < length) {
            this.decryptBuffer = new byte[length];
        }
        buf.readBytes(this.decryptBuffer, 0, length);
        return this.decryptBuffer;
    }
}

