/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.netty.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageCodec;
import io.netty.handler.codec.CorruptedFrameException;
import java.util.List;
import net.raphimc.netminecraft.packet.PacketTypes;

public class PacketSizer
extends ByteToMessageCodec<ByteBuf> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        in.markReaderIndex();
        byte[] bytes = new byte[3];
        for (int i = 0; i < bytes.length; ++i) {
            if (!in.isReadable()) {
                in.resetReaderIndex();
                return;
            }
            bytes[i] = in.readByte();
            if (bytes[i] < 0) continue;
            ByteBuf buf = Unpooled.wrappedBuffer((byte[])bytes);
            try {
                int packetLength = PacketTypes.readVarInt(buf);
                if (in.readableBytes() < packetLength) {
                    in.resetReaderIndex();
                    return;
                }
                out.add(in.readBytes(packetLength));
            }
            finally {
                buf.release();
            }
            return;
        }
        throw new CorruptedFrameException("length wider than 21-bit");
    }

    protected void encode(ChannelHandlerContext ctx, ByteBuf in, ByteBuf out) {
        int packetLength = in.readableBytes();
        int varIntLength = PacketTypes.getVarIntLength(packetLength);
        if (varIntLength > 3) {
            throw new IllegalArgumentException("Unable to fit " + packetLength + " into " + 3);
        }
        out.ensureWritable(varIntLength + packetLength);
        PacketTypes.writeVarInt(out, packetLength);
        out.writeBytes(in, in.readerIndex(), packetLength);
    }
}

