/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.netty.connection;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import java.net.SocketAddress;
import net.raphimc.netminecraft.util.EventLoops;
import net.raphimc.netminecraft.util.TransportType;

public class NetServer {
    protected final ChannelInitializer<Channel> channelInitializer;
    protected ChannelFuture channelFuture;

    public NetServer(ChannelInitializer<Channel> channelInitializer) {
        this.channelInitializer = channelInitializer;
    }

    public void initialize(TransportType transportType, ServerBootstrap bootstrap) {
        ((ServerBootstrap)((ServerBootstrap)bootstrap.group((EventLoopGroup)EventLoops.getServerParentEventLoop(transportType), (EventLoopGroup)EventLoops.getServerChildEventLoop(transportType)).channel(transportType.tcpServerChannelClass())).option(ChannelOption.SO_BACKLOG, (Object)128)).childOption(ChannelOption.TCP_NODELAY, (Object)true).childOption(ChannelOption.SO_KEEPALIVE, (Object)true).childHandler(this.channelInitializer);
        this.channelFuture = bootstrap.register().syncUninterruptibly();
    }

    public void bind(SocketAddress address) {
        this.bind(address, true);
    }

    public void bind(SocketAddress address, boolean blocking) {
        if (this.channelFuture == null) {
            this.initialize(TransportType.getBest(address), new ServerBootstrap());
        }
        this.getChannel().bind(address).syncUninterruptibly();
        if (blocking) {
            this.getChannel().closeFuture().syncUninterruptibly();
        }
    }

    public Channel getChannel() {
        if (this.channelFuture == null) {
            return null;
        }
        return this.channelFuture.channel();
    }

    public ChannelFuture getChannelFuture() {
        return this.channelFuture;
    }
}

