/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.netty.crypto;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.function.Function;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class CryptUtil {
    private static final Base64.Encoder RSA_KEY_BASE64 = Base64.getMimeEncoder(76, "\n".getBytes(StandardCharsets.UTF_8));
    public static final PublicKey MOJANG_PUBLIC_KEY;
    public static final Signature MOJANG_PUBLIC_KEY_SIGNATURE;

    public static SecretKey generateSecretKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            return keyGenerator.generateKey();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to generate AES secret key", e);
        }
    }

    public static KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance("RSA");
            keyGenerator.initialize(1024);
            return keyGenerator.generateKeyPair();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to generate RSA key pair", e);
        }
    }

    public static PublicKey decodeRsaPublicKey(byte[] key) {
        try {
            return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(key));
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to decode RSA public key", e);
        }
    }

    private static PrivateKey decodeRsaPrivateKey(byte[] key) {
        try {
            PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(key);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(encodedKeySpec);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to decode RSA private key", e);
        }
    }

    public static PublicKey decodeRsaPublicKeyPem(String key) {
        return CryptUtil.decodePem(key, "-----BEGIN RSA PUBLIC KEY-----", "-----END RSA PUBLIC KEY-----", CryptUtil::decodeRsaPublicKey);
    }

    public static PrivateKey decodeRsaPrivateKeyPem(String key) {
        return CryptUtil.decodePem(key, "-----BEGIN RSA PRIVATE KEY-----", "-----END RSA PRIVATE KEY-----", CryptUtil::decodeRsaPrivateKey);
    }

    public static String encodeRsaPublicKey(PublicKey key) {
        if (!"RSA".equals(key.getAlgorithm())) {
            throw new IllegalArgumentException("Public key must be RSA");
        }
        return "-----BEGIN RSA PUBLIC KEY-----\n" + RSA_KEY_BASE64.encodeToString(key.getEncoded()) + "\n-----END RSA PUBLIC KEY-----\n";
    }

    public static String encodeRsaPrivateKey(PrivateKey key) {
        if (!"RSA".equals(key.getAlgorithm())) {
            throw new IllegalArgumentException("Private key must be RSA");
        }
        return "-----BEGIN RSA PRIVATE KEY-----\n" + RSA_KEY_BASE64.encodeToString(key.getEncoded()) + "\n-----END RSA PRIVATE KEY-----\n";
    }

    public static SecretKey decryptSecretKey(PrivateKey privateKey, byte[] encryptedSecretKey) {
        try {
            return new SecretKeySpec(CryptUtil.decryptData(privateKey, encryptedSecretKey), "AES");
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to decrypt AES secret key", e);
        }
    }

    public static byte[] encryptData(Key key, byte[] data) {
        return CryptUtil.cryptData(1, key, data);
    }

    public static byte[] decryptData(Key key, byte[] data) {
        return CryptUtil.cryptData(2, key, data);
    }

    public static byte[] computeServerIdHash(String serverId, PublicKey publicKey, SecretKey secretKey) {
        try {
            return CryptUtil.hash(serverId.getBytes(StandardCharsets.ISO_8859_1), secretKey.getEncoded(), publicKey.getEncoded());
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to compute server id hash", e);
        }
    }

    public static boolean verifySignedNonce(PublicKey publicKey, byte[] nonce, long salt, byte[] signature) {
        try {
            Signature signer = Signature.getInstance("SHA256withRSA");
            signer.initVerify(publicKey);
            signer.update(nonce);
            signer.update(CryptUtil.long2ByteArray(salt));
            return signer.verify(signature);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to verify signed nonce", e);
        }
    }

    public static byte[] signNonce(PrivateKey privateKey, byte[] nonce, long salt) {
        try {
            Signature signer = Signature.getInstance("SHA256withRSA");
            signer.initSign(privateKey);
            signer.update(nonce);
            signer.update(CryptUtil.long2ByteArray(salt));
            return signer.sign();
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("Failed to sign nonce", e);
        }
    }

    private static byte[] cryptData(int mode, Key key, byte[] data) {
        try {
            Cipher cipher = Cipher.getInstance(key.getAlgorithm());
            cipher.init(mode, key);
            return cipher.doFinal(data);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to crypt data", e);
        }
    }

    private static byte[] hash(byte[] ... data) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
            for (byte[] array : data) {
                sha1.update(array);
            }
            return sha1.digest();
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to hash data", e);
        }
    }

    private static <T extends Key> T decodePem(String key, String prefix, String suffix, Function<byte[], T> decoder) {
        int start = key.indexOf(prefix);
        if (start != -1) {
            int end = key.indexOf(suffix, start += prefix.length());
            key = key.substring(start, end + 1);
        }
        return (T)((Key)decoder.apply(Base64.getMimeDecoder().decode(key)));
    }

    private static byte[] long2ByteArray(long value) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(value & 0xFFL);
            value >>= 8;
        }
        return result;
    }

    static {
        try {
            int len;
            InputStream is = CryptUtil.class.getClassLoader().getResourceAsStream("yggdrasil_session_pubkey.der");
            ByteArrayOutputStream publicKeyBytes = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((len = is.read(buffer)) != -1) {
                publicKeyBytes.write(buffer, 0, len);
            }
            is.close();
            MOJANG_PUBLIC_KEY = CryptUtil.decodeRsaPublicKey(publicKeyBytes.toByteArray());
            MOJANG_PUBLIC_KEY_SIGNATURE = Signature.getInstance("SHA1withRSA");
            MOJANG_PUBLIC_KEY_SIGNATURE.initVerify(MOJANG_PUBLIC_KEY);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Failed to load mojang public key and signature", e);
        }
    }
}

