/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.nbt.io.NbtIO;
import net.lenni0451.mcstructs.nbt.io.NbtReadTracker;

public class PacketTypes {
    private static final int MAX_VAR_INT_LENGTH = 5;

    public static int getVarIntLength(int value) {
        for (int i = 1; i < 5; ++i) {
            if ((value & -1 << i * 7) != 0) continue;
            return i;
        }
        return 5;
    }

    public static int readVarInt(ByteBuf byteBuf) {
        byte in;
        int value = 0;
        int bytes = 0;
        do {
            in = byteBuf.readByte();
            value |= (in & 0x7F) << bytes++ * 7;
            if (bytes <= 5) continue;
            throw new RuntimeException("VarInt too big");
        } while ((in & 0x80) == 128);
        return value;
    }

    public static ByteBuf writeVarInt(ByteBuf byteBuf, int value) {
        while ((value & 0xFFFFFF80) != 0) {
            byteBuf.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        return byteBuf.writeByte(value);
    }

    public static String readString(ByteBuf byteBuf, int maxLength) {
        int length = PacketTypes.readVarInt(byteBuf);
        if (length > maxLength * 4) {
            throw new DecoderException("The received encoded string buffer length is longer than maximum allowed (" + length + " > " + maxLength * 4 + ")");
        }
        if (length < 0) {
            throw new DecoderException("The received encoded string buffer length is less than zero! Weird string!");
        }
        String string = byteBuf.toString(byteBuf.readerIndex(), length, StandardCharsets.UTF_8);
        byteBuf.skipBytes(length);
        if (string.length() > maxLength) {
            throw new DecoderException("The received string length is longer than maximum allowed (" + length + " > " + maxLength + ")");
        }
        return string;
    }

    public static ByteBuf writeString(ByteBuf byteBuf, String string) {
        byte[] bytes = string.getBytes(StandardCharsets.UTF_8);
        return PacketTypes.writeVarInt(byteBuf, bytes.length).writeBytes(bytes);
    }

    public static byte[] readByteArray(ByteBuf byteBuf) {
        return PacketTypes.readByteArray(byteBuf, Short.MAX_VALUE);
    }

    public static byte[] readByteArray(ByteBuf byteBuf, int maxSize) {
        int length = PacketTypes.readVarInt(byteBuf);
        if (length > maxSize) {
            throw new DecoderException("The received byte array is bigger than the maximum allowed (" + length + " > " + maxSize + ")");
        }
        byte[] bytes = new byte[length];
        byteBuf.readBytes(bytes);
        return bytes;
    }

    public static ByteBuf writeByteArray(ByteBuf byteBuf, byte[] array) {
        return PacketTypes.writeVarInt(byteBuf, array.length).writeBytes(array);
    }

    public static int[] readVarIntArray(ByteBuf byteBuf) {
        return PacketTypes.readVarIntArray(byteBuf, Short.MAX_VALUE);
    }

    public static int[] readVarIntArray(ByteBuf byteBuf, int maxSize) {
        int length = PacketTypes.readVarInt(byteBuf);
        if (length > maxSize) {
            throw new DecoderException("The received integer array is bigger than the maximum allowed (" + length + " > " + maxSize + ")");
        }
        int[] array = new int[length];
        for (int i = 0; i < length; ++i) {
            array[i] = PacketTypes.readVarInt(byteBuf);
        }
        return array;
    }

    public static ByteBuf writeVarIntArray(ByteBuf byteBuf, int[] array) {
        PacketTypes.writeVarInt(byteBuf, array.length);
        for (int i : array) {
            PacketTypes.writeVarInt(byteBuf, i);
        }
        return byteBuf;
    }

    public static byte[] readShortByteArray(ByteBuf byteBuf) {
        return PacketTypes.readShortByteArray(byteBuf, Short.MAX_VALUE);
    }

    public static byte[] readShortByteArray(ByteBuf byteBuf, int maxSize) {
        short length = byteBuf.readShort();
        if (length > maxSize) {
            throw new DecoderException("The received byte array is bigger than the maximum allowed (" + length + " > " + maxSize + ")");
        }
        byte[] bytes = new byte[length];
        byteBuf.readBytes(bytes);
        return bytes;
    }

    public static ByteBuf writeShortByteArray(ByteBuf byteBuf, byte[] array) {
        return byteBuf.writeShort(array.length).writeBytes(array);
    }

    public static UUID readUuid(ByteBuf byteBuf) {
        return new UUID(byteBuf.readLong(), byteBuf.readLong());
    }

    public static ByteBuf writeUuid(ByteBuf byteBuf, UUID uuid) {
        return byteBuf.writeLong(uuid.getMostSignificantBits()).writeLong(uuid.getLeastSignificantBits());
    }

    public static byte[] readReadableBytes(ByteBuf byteBuf) {
        byte[] bytes = new byte[byteBuf.readableBytes()];
        byteBuf.readBytes(bytes);
        return bytes;
    }

    public static NbtTag readNamedTag(ByteBuf byteBuf) {
        return PacketTypes.readNamedTag(byteBuf, new NbtReadTracker());
    }

    public static NbtTag readNamedTag(ByteBuf byteBuf, NbtReadTracker readTracker) {
        try {
            return NbtIO.LATEST.read((DataInput)new ByteBufInputStream(byteBuf), readTracker);
        }
        catch (IOException e) {
            throw new DecoderException((Throwable)e);
        }
    }

    public static void writeNamedTag(ByteBuf byteBuf, NbtTag nbt) {
        try {
            NbtIO.LATEST.write((DataOutput)new ByteBufOutputStream(byteBuf), "", nbt);
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }

    public static NbtTag readUnnamedTag(ByteBuf byteBuf) {
        return PacketTypes.readUnnamedTag(byteBuf, new NbtReadTracker());
    }

    public static NbtTag readUnnamedTag(ByteBuf byteBuf, NbtReadTracker readTracker) {
        try {
            return NbtIO.LATEST.readUnnamed((DataInput)new ByteBufInputStream(byteBuf), readTracker);
        }
        catch (IOException e) {
            throw new DecoderException((Throwable)e);
        }
    }

    public static void writeUnnamedTag(ByteBuf byteBuf, NbtTag nbt) {
        try {
            NbtIO.LATEST.writeUnnamed((DataOutput)new ByteBufOutputStream(byteBuf), nbt);
        }
        catch (IOException e) {
            throw new EncoderException((Throwable)e);
        }
    }
}

