/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.packet.registry;

import io.netty.buffer.ByteBuf;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.raphimc.netminecraft.constants.ConnectionState;
import net.raphimc.netminecraft.constants.MCPackets;
import net.raphimc.netminecraft.constants.PacketDirection;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.UnknownPacket;
import net.raphimc.netminecraft.packet.registry.PacketRegistry;

public abstract class PacketRegistryImpl
implements PacketRegistry {
    private final boolean isClientside;
    private final int protocolVersion;
    private final Map<MCPackets, Supplier<Packet>> registry = new EnumMap<MCPackets, Supplier<Packet>>(MCPackets.class);
    private final Map<Class<?>, MCPackets> reverseRegistry = new HashMap();
    private ConnectionState connectionState = ConnectionState.HANDSHAKING;

    public PacketRegistryImpl(boolean isClientside, int protocolVersion) {
        this.isClientside = isClientside;
        this.protocolVersion = protocolVersion;
    }

    @Override
    public final Packet createPacket(int packetId, ByteBuf byteBuf) {
        MCPackets packetType = MCPackets.getPacket(this.connectionState, this.isClientside ? PacketDirection.CLIENTBOUND : PacketDirection.SERVERBOUND, this.protocolVersion, packetId);
        Packet packet = this.registry.getOrDefault((Object)packetType, () -> new UnknownPacket(packetId)).get();
        packet.read(byteBuf, this.protocolVersion);
        return packet;
    }

    @Override
    public int getPacketId(Packet packet) {
        if (packet instanceof UnknownPacket) {
            return ((UnknownPacket)packet).packetId;
        }
        Class<?> packetClass = packet.getClass();
        if (!this.reverseRegistry.containsKey(packetClass)) {
            throw new IllegalArgumentException("Packet " + packetClass.getSimpleName() + " is not registered in the packet registry");
        }
        int packetId = this.reverseRegistry.get(packetClass).getId(this.protocolVersion);
        if (packetId == -1) {
            throw new IllegalArgumentException("Packet " + packetClass.getSimpleName() + " is not available for protocol version " + this.protocolVersion);
        }
        return packetId;
    }

    @Override
    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public final ConnectionState getConnectionState() {
        return this.connectionState;
    }

    @Override
    public final void setConnectionState(ConnectionState connectionState) {
        this.connectionState = connectionState;
    }

    protected final void registerPacket(MCPackets packetType, Supplier<Packet> packetCreator) {
        this.unregisterPacket(packetType);
        Class<?> packetClass = packetCreator.get().getClass();
        this.registry.put(packetType, packetCreator);
        if (this.reverseRegistry.put(packetClass, packetType) != null) {
            throw new IllegalArgumentException("Packet " + packetClass.getSimpleName() + " is already registered in the packet registry");
        }
    }

    protected final void unregisterPacket(MCPackets packetType) {
        this.registry.remove((Object)packetType);
        this.reverseRegistry.values().removeIf(packetType::equals);
    }
}

