/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.util;

import io.netty.channel.MultiThreadIoEventLoopGroup;
import java.util.EnumMap;
import net.raphimc.netminecraft.util.ThreadFactoryBuilder;
import net.raphimc.netminecraft.util.TransportType;

public class EventLoops {
    private static final EnumMap<TransportType, MultiThreadIoEventLoopGroup> CLIENT_EVENT_LOOPS = new EnumMap(TransportType.class);
    private static final EnumMap<TransportType, MultiThreadIoEventLoopGroup> SERVER_PARENT_EVENT_LOOPS = new EnumMap(TransportType.class);
    private static final EnumMap<TransportType, MultiThreadIoEventLoopGroup> SERVER_CHILD_EVENT_LOOPS = new EnumMap(TransportType.class);

    public static synchronized MultiThreadIoEventLoopGroup getClientEventLoop(TransportType transportType) {
        return CLIENT_EVENT_LOOPS.computeIfAbsent(transportType, transport -> {
            ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setNameFormat("Netty " + transport.name() + " Client IO #%d").setDaemon(true);
            return new MultiThreadIoEventLoopGroup(0, threadFactoryBuilder.build(), transport.ioHandlerFactorySupplier().get());
        });
    }

    public static synchronized MultiThreadIoEventLoopGroup getServerParentEventLoop(TransportType transportType) {
        return SERVER_PARENT_EVENT_LOOPS.computeIfAbsent(transportType, transport -> {
            ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setNameFormat("Netty " + transport.name() + " Server Parent IO #%d").setDaemon(true);
            return new MultiThreadIoEventLoopGroup(0, threadFactoryBuilder.build(), transport.ioHandlerFactorySupplier().get());
        });
    }

    public static synchronized MultiThreadIoEventLoopGroup getServerChildEventLoop(TransportType transportType) {
        return SERVER_CHILD_EVENT_LOOPS.computeIfAbsent(transportType, transport -> {
            ThreadFactoryBuilder threadFactoryBuilder = new ThreadFactoryBuilder().setNameFormat("Netty " + transport.name() + " Server Child IO #%d").setDaemon(true);
            return new MultiThreadIoEventLoopGroup(0, threadFactoryBuilder.build(), transport.ioHandlerFactorySupplier().get());
        });
    }
}

