/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.util;

import java.net.InetSocketAddress;
import java.util.Hashtable;
import javax.naming.directory.Attributes;
import javax.naming.directory.InitialDirContext;

public class MinecraftServerAddress
extends InetSocketAddress {
    private static final String DNS_CONTEXT_FACTORY_CLASS = "com.sun.jndi.dns.DnsContextFactory";

    MinecraftServerAddress(String address, int port) {
        super(address, port);
    }

    public static MinecraftServerAddress ofUnresolved(String address, int port) {
        return new MinecraftServerAddress(address, port);
    }

    public static MinecraftServerAddress ofUnresolved(String address) {
        int index;
        String[] addressParts = address.split(":");
        if (address.startsWith("[") && (index = address.indexOf("]")) > 0) {
            String ipv6Part = address.substring(1, index);
            String extraData = address.substring(index + 1).trim();
            if (extraData.startsWith(":")) {
                extraData = extraData.substring(1);
                addressParts = new String[]{ipv6Part, extraData};
            } else {
                addressParts = new String[]{ipv6Part};
            }
        }
        if (addressParts.length > 2) {
            addressParts = new String[]{address};
        }
        int port = addressParts.length > 1 ? MinecraftServerAddress.portOrDefault(addressParts[1], 25565) : 25565;
        return new MinecraftServerAddress(addressParts[0], port);
    }

    public static MinecraftServerAddress ofResolved(String address, int port) {
        return MinecraftServerAddress.resolveSrv(MinecraftServerAddress.ofUnresolved(address, port));
    }

    public static MinecraftServerAddress ofResolved(String address) {
        return MinecraftServerAddress.resolveSrv(MinecraftServerAddress.ofUnresolved(address));
    }

    private static MinecraftServerAddress resolveSrv(MinecraftServerAddress unresolved) {
        if (unresolved.getPort() == 25565) {
            try {
                Class.forName(DNS_CONTEXT_FACTORY_CLASS);
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("java.naming.factory.initial", DNS_CONTEXT_FACTORY_CLASS);
                hashtable.put("java.naming.provider.url", "dns:");
                hashtable.put("com.sun.jndi.dns.timeout.retries", "1");
                InitialDirContext dirContext = new InitialDirContext(hashtable);
                Attributes attributes = dirContext.getAttributes("_minecraft._tcp." + unresolved.getHostString(), new String[]{"SRV"});
                String[] srvRecord = attributes.get("srv").get().toString().split(" ", 4);
                return new MinecraftServerAddress(srvRecord[3], MinecraftServerAddress.portOrDefault(srvRecord[2], 25565));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return unresolved;
    }

    private static int portOrDefault(String port, int defaultPort) {
        try {
            return Integer.parseInt(port.trim());
        }
        catch (NumberFormatException e) {
            return defaultPort;
        }
    }
}

