/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.packet.impl.login;

import io.netty.buffer.ByteBuf;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.PacketTypes;

public class S2CLoginHelloPacket
implements Packet {
    public String serverId;
    public byte[] publicKey;
    public byte[] nonce;
    public boolean authenticate;

    public S2CLoginHelloPacket() {
    }

    public S2CLoginHelloPacket(String serverId, byte[] publicKey, byte[] nonce) {
        this.serverId = serverId;
        this.publicKey = publicKey;
        this.nonce = nonce;
    }

    public S2CLoginHelloPacket(String serverId, byte[] publicKey, byte[] nonce, boolean authenticate) {
        this(serverId, publicKey, nonce);
        this.authenticate = authenticate;
    }

    public void read(ByteBuf byteBuf, int protocolVersion) {
        this.serverId = PacketTypes.readString((ByteBuf)byteBuf, (int)20);
        if (protocolVersion <= 5) {
            this.publicKey = PacketTypes.readShortByteArray((ByteBuf)byteBuf);
            this.nonce = PacketTypes.readShortByteArray((ByteBuf)byteBuf);
        } else {
            this.publicKey = PacketTypes.readByteArray((ByteBuf)byteBuf);
            this.nonce = PacketTypes.readByteArray((ByteBuf)byteBuf);
        }
        if (protocolVersion >= 766) {
            this.authenticate = byteBuf.readBoolean();
        }
    }

    public void write(ByteBuf byteBuf, int protocolVersion) {
        PacketTypes.writeString((ByteBuf)byteBuf, (String)this.serverId);
        if (protocolVersion <= 5) {
            PacketTypes.writeShortByteArray((ByteBuf)byteBuf, (byte[])this.publicKey);
            PacketTypes.writeShortByteArray((ByteBuf)byteBuf, (byte[])this.nonce);
        } else {
            PacketTypes.writeByteArray((ByteBuf)byteBuf, (byte[])this.publicKey);
            PacketTypes.writeByteArray((ByteBuf)byteBuf, (byte[])this.nonce);
        }
        if (protocolVersion >= 766) {
            byteBuf.writeBoolean(this.authenticate);
        }
    }
}

