/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.packet.impl.common;

import io.netty.buffer.ByteBuf;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.PacketTypes;

public abstract class C2SCustomPayloadPacket
implements Packet {
    public String channel;
    public byte[] data;

    public C2SCustomPayloadPacket() {
    }

    public C2SCustomPayloadPacket(String channel, byte[] data) {
        this.channel = channel;
        this.data = data;
    }

    public void read(ByteBuf byteBuf, int protocolVersion) {
        this.channel = PacketTypes.readString((ByteBuf)byteBuf, (int)Short.MAX_VALUE);
        int length = protocolVersion <= 5 ? byteBuf.readShort() : byteBuf.readableBytes();
        this.data = new byte[length];
        byteBuf.readBytes(this.data);
        if (protocolVersion <= 5) {
            byteBuf.skipBytes(byteBuf.readableBytes());
        }
    }

    public void write(ByteBuf byteBuf, int protocolVersion) {
        PacketTypes.writeString((ByteBuf)byteBuf, (String)this.channel);
        if (protocolVersion <= 5) {
            byteBuf.writeShort(this.data.length);
        }
        byteBuf.writeBytes(this.data);
    }
}

