/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.packet.impl.common;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.PacketTypes;

public abstract class C2SResourcePackPacket
implements Packet {
    public int status;
    public UUID packId;
    public String hash;

    public C2SResourcePackPacket() {
    }

    public C2SResourcePackPacket(int status) {
        this.status = status;
    }

    public C2SResourcePackPacket(int status, UUID packId) {
        this.status = status;
        this.packId = packId;
    }

    public C2SResourcePackPacket(int status, UUID packId, String hash) {
        this.status = status;
        this.packId = packId;
        this.hash = hash;
    }

    public void read(ByteBuf byteBuf, int protocolVersion) {
        if (protocolVersion <= 110) {
            this.hash = PacketTypes.readString((ByteBuf)byteBuf, (int)40);
        }
        if (protocolVersion >= 765) {
            this.packId = PacketTypes.readUuid((ByteBuf)byteBuf);
        }
        this.status = PacketTypes.readVarInt((ByteBuf)byteBuf);
    }

    public void write(ByteBuf byteBuf, int protocolVersion) {
        if (protocolVersion <= 110) {
            PacketTypes.writeString((ByteBuf)byteBuf, (String)this.hash);
        }
        if (protocolVersion >= 765) {
            PacketTypes.writeUuid((ByteBuf)byteBuf, (UUID)this.packId);
        }
        PacketTypes.writeVarInt((ByteBuf)byteBuf, (int)this.status);
    }
}

