/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.packet.impl.common;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.text.TextComponent;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.PacketTypes;
import net.raphimc.netminecraft.packet.SerializerTypes;

public abstract class S2CResourcePackPushPacket
implements Packet {
    public UUID packId;
    public String url;
    public String hash;
    public boolean required;
    public TextComponent message;

    public S2CResourcePackPushPacket() {
    }

    public S2CResourcePackPushPacket(UUID packId, String url, String hash, boolean required, TextComponent message) {
        this.packId = packId;
        this.url = url;
        this.hash = hash;
        this.required = required;
        this.message = message;
    }

    public void read(ByteBuf byteBuf, int protocolVersion) {
        this.packId = PacketTypes.readUuid((ByteBuf)byteBuf);
        this.url = PacketTypes.readString((ByteBuf)byteBuf, (int)Short.MAX_VALUE);
        this.hash = PacketTypes.readString((ByteBuf)byteBuf, (int)40);
        this.required = byteBuf.readBoolean();
        if (byteBuf.readBoolean()) {
            this.message = SerializerTypes.getTextComponentSerializer((int)protocolVersion).getParentCodec().deserialize(PacketTypes.readUnnamedTag((ByteBuf)byteBuf));
        }
    }

    public void write(ByteBuf byteBuf, int protocolVersion) {
        PacketTypes.writeUuid((ByteBuf)byteBuf, (UUID)this.packId);
        PacketTypes.writeString((ByteBuf)byteBuf, (String)this.url);
        PacketTypes.writeString((ByteBuf)byteBuf, (String)this.hash);
        byteBuf.writeBoolean(this.required);
        byteBuf.writeBoolean(this.message != null);
        if (this.message != null) {
            PacketTypes.writeUnnamedTag((ByteBuf)byteBuf, (NbtTag)SerializerTypes.getTextComponentSerializer((int)protocolVersion).getParentCodec().serializeNbtTree(this.message));
        }
    }
}

