/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.packet.impl.common;

import io.netty.buffer.ByteBuf;
import net.lenni0451.mcstructs.nbt.NbtTag;
import net.lenni0451.mcstructs.text.TextComponent;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.PacketTypes;
import net.raphimc.netminecraft.packet.SerializerTypes;

public abstract class S2CResourcePackPacket
implements Packet {
    public String url;
    public String hash;
    public boolean required;
    public TextComponent message;

    public S2CResourcePackPacket() {
    }

    public S2CResourcePackPacket(String url, String hash, boolean required, TextComponent message) {
        this.url = url;
        this.hash = hash;
        this.required = required;
        this.message = message;
    }

    public void read(ByteBuf byteBuf, int protocolVersion) {
        this.url = PacketTypes.readString((ByteBuf)byteBuf, (int)Short.MAX_VALUE);
        this.hash = PacketTypes.readString((ByteBuf)byteBuf, (int)40);
        if (protocolVersion >= 755) {
            this.required = byteBuf.readBoolean();
            if (byteBuf.readBoolean()) {
                this.message = protocolVersion <= 764 ? SerializerTypes.getTextComponentSerializer((int)protocolVersion).deserialize(PacketTypes.readString((ByteBuf)byteBuf, (int)262144)) : SerializerTypes.getTextComponentSerializer((int)protocolVersion).getParentCodec().deserialize(PacketTypes.readUnnamedTag((ByteBuf)byteBuf));
            }
        }
    }

    public void write(ByteBuf byteBuf, int protocolVersion) {
        PacketTypes.writeString((ByteBuf)byteBuf, (String)this.url);
        PacketTypes.writeString((ByteBuf)byteBuf, (String)this.hash);
        if (protocolVersion >= 755) {
            byteBuf.writeBoolean(this.required);
            byteBuf.writeBoolean(this.message != null);
            if (this.message != null) {
                if (protocolVersion <= 764) {
                    PacketTypes.writeString((ByteBuf)byteBuf, (String)SerializerTypes.getTextComponentSerializer((int)protocolVersion).serialize(this.message));
                } else {
                    PacketTypes.writeUnnamedTag((ByteBuf)byteBuf, (NbtTag)SerializerTypes.getTextComponentSerializer((int)protocolVersion).getParentCodec().serializeNbtTree(this.message));
                }
            }
        }
    }
}

