/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.packet.impl.login;

import io.netty.buffer.ByteBuf;
import java.security.PublicKey;
import java.time.Instant;
import java.util.UUID;
import net.raphimc.netminecraft.netty.crypto.CryptUtil;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.PacketTypes;

public class C2SLoginHelloPacket
implements Packet {
    public String name;
    public Instant expiresAt;
    public PublicKey key;
    public byte[] keySignature;
    public UUID uuid;

    public C2SLoginHelloPacket() {
    }

    public C2SLoginHelloPacket(String name) {
        this.name = name;
    }

    public C2SLoginHelloPacket(String name, Instant expiresAt, PublicKey key, byte[] keySignature) {
        this(name);
        this.expiresAt = expiresAt;
        this.key = key;
        this.keySignature = keySignature;
    }

    public C2SLoginHelloPacket(String name, Instant expiresAt, PublicKey key, byte[] keySignature, UUID uuid) {
        this(name, expiresAt, key, keySignature);
        this.uuid = uuid;
    }

    public void read(ByteBuf byteBuf, int protocolVersion) {
        this.name = PacketTypes.readString((ByteBuf)byteBuf, (int)16);
        if (protocolVersion >= 759 && protocolVersion <= 760 && byteBuf.readBoolean()) {
            this.expiresAt = Instant.ofEpochMilli(byteBuf.readLong());
            this.key = CryptUtil.decodeRsaPublicKey((byte[])PacketTypes.readByteArray((ByteBuf)byteBuf, (int)512));
            this.keySignature = PacketTypes.readByteArray((ByteBuf)byteBuf, (int)4096);
        }
        if (protocolVersion >= 760 && protocolVersion <= 763) {
            if (byteBuf.readBoolean()) {
                this.uuid = PacketTypes.readUuid((ByteBuf)byteBuf);
            }
        } else if (protocolVersion >= 764) {
            this.uuid = PacketTypes.readUuid((ByteBuf)byteBuf);
        }
    }

    public void write(ByteBuf byteBuf, int protocolVersion) {
        PacketTypes.writeString((ByteBuf)byteBuf, (String)this.name);
        if (protocolVersion >= 759 && protocolVersion <= 760) {
            boolean hasKeyData = this.expiresAt != null && this.key != null && this.keySignature != null;
            byteBuf.writeBoolean(hasKeyData);
            if (hasKeyData) {
                byteBuf.writeLong(this.expiresAt.toEpochMilli());
                PacketTypes.writeByteArray((ByteBuf)byteBuf, (byte[])this.key.getEncoded());
                PacketTypes.writeByteArray((ByteBuf)byteBuf, (byte[])this.keySignature);
            }
        }
        if (protocolVersion >= 760 && protocolVersion <= 763) {
            byteBuf.writeBoolean(this.uuid != null);
            if (this.uuid != null) {
                PacketTypes.writeUuid((ByteBuf)byteBuf, (UUID)this.uuid);
            }
        } else if (protocolVersion >= 764) {
            PacketTypes.writeUuid((ByteBuf)byteBuf, (UUID)this.uuid);
        }
    }
}

