/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.packet.impl.login;

import io.netty.buffer.ByteBuf;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.PacketTypes;

public class C2SLoginKeyPacket
implements Packet {
    public byte[] encryptedSecretKey;
    public byte[] encryptedNonce;
    public Long salt;
    public byte[] signature;

    public C2SLoginKeyPacket() {
    }

    public C2SLoginKeyPacket(byte[] encryptedSecretKey, byte[] encryptedNonce) {
        this.encryptedSecretKey = encryptedSecretKey;
        this.encryptedNonce = encryptedNonce;
    }

    public C2SLoginKeyPacket(byte[] encryptedSecretKey, long salt, byte[] signature) {
        this(encryptedSecretKey, null);
        this.salt = salt;
        this.signature = signature;
    }

    public void read(ByteBuf byteBuf, int protocolVersion) {
        if (protocolVersion <= 5) {
            this.encryptedSecretKey = PacketTypes.readShortByteArray((ByteBuf)byteBuf);
            this.encryptedNonce = PacketTypes.readShortByteArray((ByteBuf)byteBuf);
        } else {
            this.encryptedSecretKey = PacketTypes.readByteArray((ByteBuf)byteBuf);
            if (protocolVersion >= 759 && protocolVersion <= 760) {
                if (!byteBuf.readBoolean()) {
                    this.salt = byteBuf.readLong();
                    this.signature = PacketTypes.readByteArray((ByteBuf)byteBuf);
                } else {
                    this.encryptedNonce = PacketTypes.readByteArray((ByteBuf)byteBuf);
                }
            } else {
                this.encryptedNonce = PacketTypes.readByteArray((ByteBuf)byteBuf);
            }
        }
    }

    public void write(ByteBuf byteBuf, int protocolVersion) {
        if (protocolVersion <= 5) {
            PacketTypes.writeShortByteArray((ByteBuf)byteBuf, (byte[])this.encryptedSecretKey);
            PacketTypes.writeShortByteArray((ByteBuf)byteBuf, (byte[])this.encryptedNonce);
        } else {
            PacketTypes.writeByteArray((ByteBuf)byteBuf, (byte[])this.encryptedSecretKey);
            if (protocolVersion >= 759 && protocolVersion <= 760) {
                boolean isSigned = this.salt != null && this.signature != null;
                byteBuf.writeBoolean(!isSigned);
                if (isSigned) {
                    byteBuf.writeLong(this.salt.longValue());
                    PacketTypes.writeByteArray((ByteBuf)byteBuf, (byte[])this.signature);
                } else {
                    PacketTypes.writeByteArray((ByteBuf)byteBuf, (byte[])this.encryptedNonce);
                }
            } else {
                PacketTypes.writeByteArray((ByteBuf)byteBuf, (byte[])this.encryptedNonce);
            }
        }
    }
}

