/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.netminecraft.packet.impl.login;

import io.netty.buffer.ByteBuf;
import net.raphimc.netminecraft.packet.Packet;
import net.raphimc.netminecraft.packet.PacketTypes;

public class S2CLoginCustomQueryPacket
implements Packet {
    public int queryId;
    public String channel;
    public byte[] payload;

    public S2CLoginCustomQueryPacket() {
    }

    public S2CLoginCustomQueryPacket(int queryId, String channel, byte[] payload) {
        this.queryId = queryId;
        this.channel = channel;
        this.payload = payload;
    }

    public void read(ByteBuf byteBuf, int protocolVersion) {
        this.queryId = PacketTypes.readVarInt((ByteBuf)byteBuf);
        this.channel = PacketTypes.readString((ByteBuf)byteBuf, (int)Short.MAX_VALUE);
        int length = byteBuf.readableBytes();
        if (length < 0 || length > 0x100000) {
            throw new IllegalStateException("Payload may not be larger than 1048576 bytes");
        }
        this.payload = new byte[length];
        byteBuf.readBytes(this.payload);
    }

    public void write(ByteBuf byteBuf, int protocolVersion) {
        PacketTypes.writeVarInt((ByteBuf)byteBuf, (int)this.queryId);
        PacketTypes.writeString((ByteBuf)byteBuf, (String)this.channel);
        byteBuf.writeBytes(this.payload);
    }
}

